/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.dom.field.ContentDispositionField;
import org.apache.james.mime4j.dom.field.ContentTransferEncodingField;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.field.Fields;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.NameValuePair;
import org.apache.james.mime4j.util.MimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityBuilder {
    private final List<Field> fields = new LinkedList<Field>();
    private final Map<String, List<Field>> fieldMap = new HashMap<String, List<Field>>();
    private Body body;

    public AbstractEntityBuilder addField(Field field) {
        List<Field> values = this.fieldMap.get(field.getName().toLowerCase(Locale.US));
        if (values == null) {
            values = new LinkedList<Field>();
            this.fieldMap.put(field.getName().toLowerCase(Locale.US), values);
        }
        values.add(field);
        this.fields.add(field);
        return this;
    }

    public List<Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Field getField(String name) {
        List<Field> l = this.fieldMap.get(name.toLowerCase(Locale.US));
        if (l != null && !l.isEmpty()) {
            return l.get(0);
        }
        return null;
    }

    public <F extends Field> F getField(String name, Class<F> clazz) {
        List<Field> l = this.fieldMap.get(name.toLowerCase(Locale.US));
        for (int i = 0; i < l.size(); ++i) {
            Field field = l.get(i);
            if (!clazz.isInstance(field)) continue;
            return (F)((Field)clazz.cast(field));
        }
        return null;
    }

    public boolean containsField(String name) {
        List<Field> l = this.fieldMap.get(name.toLowerCase(Locale.US));
        return l != null && !l.isEmpty();
    }

    public List<Field> getFields(String name) {
        String lowerCaseName = name.toLowerCase(Locale.US);
        List<Field> l = this.fieldMap.get(lowerCaseName);
        List<Field> results = l == null || l.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(l);
        return results;
    }

    public <F extends Field> List<F> getFields(String name, Class<F> clazz) {
        String lowerCaseName = name.toLowerCase(Locale.US);
        List<Field> l = this.fieldMap.get(lowerCaseName);
        if (l == null) {
            return Collections.emptyList();
        }
        ArrayList<F> results = new ArrayList<F>();
        for (int i = 0; i < l.size(); ++i) {
            Field field = l.get(i);
            if (!clazz.isInstance(field)) continue;
            results.add(clazz.cast(field));
        }
        return results;
    }

    public AbstractEntityBuilder removeFields(String name) {
        String lowerCaseName = name.toLowerCase(Locale.US);
        List<Field> removed = this.fieldMap.remove(lowerCaseName);
        if (removed == null || removed.isEmpty()) {
            return this;
        }
        Iterator<Field> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            Field field = iterator.next();
            if (!field.getName().equalsIgnoreCase(name)) continue;
            iterator.remove();
        }
        return this;
    }

    public AbstractEntityBuilder setField(Field field) {
        String lowerCaseName = field.getName().toLowerCase(Locale.US);
        List<Field> l = this.fieldMap.get(lowerCaseName);
        if (l == null || l.isEmpty()) {
            this.addField(field);
            return this;
        }
        l.clear();
        l.add(field);
        int firstOccurrence = -1;
        int index = 0;
        Iterator<Field> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            Field f = iterator.next();
            if (f.getName().equalsIgnoreCase(field.getName())) {
                iterator.remove();
                if (firstOccurrence == -1) {
                    firstOccurrence = index;
                }
            }
            ++index;
        }
        this.fields.add(firstOccurrence, field);
        return this;
    }

    public AbstractEntityBuilder clearFields() {
        this.fields.clear();
        this.fieldMap.clear();
        return this;
    }

    public <F extends ParsedField> F obtainField(String fieldName) {
        return (F)((ParsedField)this.getField(fieldName));
    }

    public String getMimeType() {
        ContentTypeField field = (ContentTypeField)this.obtainField("Content-Type");
        return field != null ? field.getMimeType() : null;
    }

    public String getCharset() {
        ContentTypeField field = (ContentTypeField)this.obtainField("Content-Type");
        return field != null ? field.getCharset() : null;
    }

    public AbstractEntityBuilder setContentType(String mimeType, NameValuePair ... parameters) {
        if (mimeType == null) {
            this.removeFields("Content-Type");
        } else {
            this.setField(Fields.contentType(mimeType, parameters));
        }
        return this;
    }

    public String getContentTransferEncoding() {
        ContentTransferEncodingField field = (ContentTransferEncodingField)this.obtainField("Content-Transfer-Encoding");
        return field != null ? field.getEncoding() : null;
    }

    public AbstractEntityBuilder setContentTransferEncoding(String contentTransferEncoding) {
        if (contentTransferEncoding == null) {
            this.removeFields("Content-Transfer-Encoding");
        } else {
            this.setField(Fields.contentTransferEncoding(contentTransferEncoding));
        }
        return this;
    }

    public String getDispositionType() {
        ContentDispositionField field = (ContentDispositionField)this.obtainField("Content-Disposition");
        return field != null ? field.getDispositionType() : null;
    }

    public AbstractEntityBuilder setContentDisposition(String dispositionType) {
        if (dispositionType == null) {
            this.removeFields("Content-Disposition");
        } else {
            this.setField(Fields.contentDisposition(dispositionType));
        }
        return this;
    }

    public AbstractEntityBuilder setContentDisposition(String dispositionType, String filename) {
        if (dispositionType == null) {
            this.removeFields("Content-Disposition");
        } else {
            this.setField(Fields.contentDisposition(dispositionType, filename));
        }
        return this;
    }

    public AbstractEntityBuilder setContentDisposition(String dispositionType, String filename, long size) {
        if (dispositionType == null) {
            this.removeFields("Content-Disposition");
        } else {
            this.setField(Fields.contentDisposition(dispositionType, filename, size));
        }
        return this;
    }

    public AbstractEntityBuilder setContentDisposition(String dispositionType, String filename, long size, Date creationDate, Date modificationDate, Date readDate) {
        if (dispositionType == null) {
            this.removeFields("Content-Disposition");
        } else {
            this.setField(Fields.contentDisposition(dispositionType, filename, size, creationDate, modificationDate, readDate));
        }
        return this;
    }

    public String getFilename() {
        ContentDispositionField field = (ContentDispositionField)this.obtainField("Content-Disposition");
        return field != null ? field.getFilename() : null;
    }

    public long getSize() {
        ContentDispositionField field = (ContentDispositionField)this.obtainField("Content-Disposition");
        return field != null ? field.getSize() : -1L;
    }

    public Date getCreationDate() {
        ContentDispositionField field = (ContentDispositionField)this.obtainField("Content-Disposition");
        return field != null ? field.getCreationDate() : null;
    }

    public Date getModificationDate() {
        ContentDispositionField field = (ContentDispositionField)this.obtainField("Content-Disposition");
        return field != null ? field.getModificationDate() : null;
    }

    public Date getReadDate() {
        ContentDispositionField field = (ContentDispositionField)this.obtainField("Content-Disposition");
        return field != null ? field.getReadDate() : null;
    }

    public AbstractEntityBuilder setBody(Body body) {
        this.body = body;
        if (body == null) {
            this.removeFields("Content-Type");
        }
        return this;
    }

    public AbstractEntityBuilder setBody(TextBody textBody) {
        this.body = textBody;
        if (textBody != null) {
            String mimeCharset = textBody.getMimeCharset();
            if ("us-ascii".equalsIgnoreCase(mimeCharset)) {
                mimeCharset = null;
            }
            if (mimeCharset != null) {
                this.setField(Fields.contentType("text/plain", new NameValuePair("charset", mimeCharset)));
            } else {
                this.setField(Fields.contentType("text/plain"));
            }
        } else {
            this.removeFields("Content-Type");
        }
        return this;
    }

    public AbstractEntityBuilder setBody(BinaryBody binaryBody) {
        this.body = binaryBody;
        if (binaryBody != null) {
            this.setField(Fields.contentType("application/octet-stream"));
        } else {
            this.removeFields("Content-Type");
        }
        return this;
    }

    public AbstractEntityBuilder setBody(Message message) {
        this.body = message;
        if (message != null) {
            this.setField(Fields.contentType("message/rfc822"));
        } else {
            this.removeFields("Content-Type");
        }
        return this;
    }

    public AbstractEntityBuilder setBody(Multipart multipart) {
        this.body = multipart;
        if (multipart != null) {
            this.setField(Fields.contentType("multipart/" + multipart.getSubType(), new NameValuePair("boundary", MimeUtil.createUniqueBoundary())));
        } else {
            this.removeFields("Content-Type");
        }
        return this;
    }

    public Body getBody() {
        return this.body;
    }
}

