/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.util.Collections;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.UnknownNameException;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.DefaultScopedName;
import org.apache.sis.util.iso.DefaultTypeName;
import org.apache.sis.util.iso.TypeNames;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;
import org.opengis.util.TypeName;

public final class Names
extends Static {
    private Names() {
    }

    private static NameSpace createNameSpace(NameFactory nameFactory, CharSequence charSequence, String string) {
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        return nameFactory.createNameSpace(nameFactory.createLocalName(null, charSequence), string == null ? null : Collections.singletonMap("separator.head", string));
    }

    public static GenericName parseGenericName(CharSequence charSequence, String string, CharSequence charSequence2) {
        ArgumentChecks.ensureNonNull("localPart", charSequence2);
        NameFactory nameFactory = DefaultFactories.forBuildin(NameFactory.class);
        return nameFactory.parseGenericName(Names.createNameSpace(nameFactory, charSequence, string), charSequence2);
    }

    public static ScopedName createScopedName(GenericName genericName, String string, CharSequence charSequence) {
        return new DefaultScopedName(genericName, string, charSequence);
    }

    public static LocalName createLocalName(CharSequence charSequence, String string, CharSequence charSequence2) {
        ArgumentChecks.ensureNonNull("localPart", charSequence2);
        NameFactory nameFactory = DefaultFactories.forBuildin(NameFactory.class);
        return nameFactory.createLocalName(Names.createNameSpace(nameFactory, charSequence, string), charSequence2);
    }

    public static TypeName createTypeName(CharSequence charSequence, String string, CharSequence charSequence2) {
        ArgumentChecks.ensureNonNull("localPart", charSequence2);
        NameFactory nameFactory = DefaultFactories.forBuildin(NameFactory.class);
        return nameFactory.createTypeName(Names.createNameSpace(nameFactory, charSequence, string), charSequence2);
    }

    public static MemberName createMemberName(CharSequence charSequence, String string, CharSequence charSequence2, Class<?> clazz) {
        ArgumentChecks.ensureNonNull("localPart", charSequence2);
        ArgumentChecks.ensureNonNull("valueClass", clazz);
        DefaultNameFactory defaultNameFactory = DefaultFactories.forBuildin(NameFactory.class, DefaultNameFactory.class);
        return defaultNameFactory.createMemberName(Names.createNameSpace(defaultNameFactory, charSequence, string), charSequence2, defaultNameFactory.toTypeName(clazz));
    }

    public static Class<?> toClass(TypeName typeName) throws UnknownNameException {
        Class<?> clazz;
        if (typeName == null) {
            return null;
        }
        if (typeName instanceof DefaultTypeName) {
            clazz = ((DefaultTypeName)typeName).toClass();
        } else {
            try {
                clazz = TypeNames.toClass(TypeNames.namespace(typeName.scope()), typeName.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UnknownNameException(TypeNames.unknown(typeName), classNotFoundException);
            }
            if (clazz == null) {
                throw new UnknownNameException(TypeNames.unknown(typeName));
            }
            if (clazz == Void.TYPE) {
                clazz = null;
            }
        }
        return clazz;
    }

    public static String toExpandedString(GenericName genericName) {
        if (genericName == null) {
            return null;
        }
        String string = genericName.toString();
        NameSpace nameSpace = genericName.scope();
        if (nameSpace == null || nameSpace.isGlobal()) {
            return string;
        }
        String string2 = nameSpace.name().toString();
        return new StringBuilder(string2.length() + string.length() + 2).append('{').append(string2).append('}').append(string).toString();
    }
}

