/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.analysis;

import at.ac.tuwien.dbai.pdfwrap.comparators.XYTextComparator;
import at.ac.tuwien.dbai.pdfwrap.model.document.CharSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.CompositeSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.LineFragment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextFragment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextLine;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextSegment;
import at.ac.tuwien.dbai.pdfwrap.utils.SegmentUtils;
import at.ac.tuwien.dbai.pdfwrap.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LineProcessor {
    public static List<TextLine> findLinesFromLineFragments(List<LineFragment> textBlocks, float maxX, boolean postNG, boolean ignoreFontsize) {
        ArrayList<TextLine> retVal = new ArrayList<TextLine>();
        List<CompositeSegment<? extends TextSegment>> foundLines = LineProcessor.findLines(textBlocks, maxX, postNG, ignoreFontsize);
        for (CompositeSegment<? extends TextSegment> cs : foundLines) {
            TextLine tl = new TextLine();
            tl.getItems().addAll(cs.getItems());
            tl.setCalculatedFields(cs);
            retVal.add(tl);
        }
        return retVal;
    }

    public static List<TextLine> findLinesFromTextFragments(List<TextFragment> textBlocks, float maxX, boolean postNG, boolean ignoreFontsize) {
        ArrayList<TextLine> retVal = new ArrayList<TextLine>();
        List<CompositeSegment<? extends TextSegment>> foundLines = LineProcessor.findLines(textBlocks, maxX, postNG, ignoreFontsize);
        for (CompositeSegment<? extends TextSegment> cs : foundLines) {
            LineFragment lf = new LineFragment();
            lf.getItems().addAll(cs.getItems());
            lf.setCalculatedFields(cs);
            TextLine tl = new TextLine();
            tl.getItems().add(lf);
            tl.setCalculatedFields(lf);
            retVal.add(tl);
        }
        return retVal;
    }

    public static List<TextLine> findLinesFromCharacters(List<CharSegment> textBlocks, float maxX, boolean postNG, boolean ignoreFontsize) {
        ArrayList<TextLine> retVal = new ArrayList<TextLine>();
        List<CompositeSegment<? extends TextSegment>> foundLines = LineProcessor.findLines(textBlocks, maxX, postNG, ignoreFontsize);
        for (CompositeSegment<? extends TextSegment> cs : foundLines) {
            TextFragment tf = new TextFragment();
            tf.getItems().addAll(cs.getItems());
            tf.setCalculatedFields(cs);
            LineFragment lf = new LineFragment();
            lf.getItems().add(tf);
            lf.setCalculatedFields(tf);
            TextLine tl = new TextLine();
            tl.getItems().add(lf);
            tl.setCalculatedFields(lf);
            retVal.add(tl);
        }
        return retVal;
    }

    public static List<TextLine> findLinesFromTextLines(List<TextLine> textBlocks, float maxX, boolean postNG, boolean ignoreFontsize) {
        ArrayList<TextLine> retVal = new ArrayList<TextLine>();
        List<CompositeSegment<? extends TextSegment>> foundLines = LineProcessor.findLines(textBlocks, maxX, postNG, ignoreFontsize);
        for (CompositeSegment<? extends TextSegment> cs : foundLines) {
            TextLine tl = new TextLine();
            for (TextSegment textSegment : cs.getItems()) {
                TextLine tl2 = (TextLine)textSegment;
                tl.getItems().addAll(tl2.getItems());
            }
            tl.setCalculatedFields(cs);
            retVal.add(tl);
        }
        return retVal;
    }

    public static List<CompositeSegment<? extends TextSegment>> findLines(List<? extends TextSegment> textBlocks, float maxX, boolean postNG, boolean ignoreFontsize) {
        Collections.sort(textBlocks, new XYTextComparator());
        ArrayList<CompositeSegment<? extends TextSegment>> retVal = new ArrayList<CompositeSegment<? extends TextSegment>>();
        TextSegment lastBlock = null;
        ArrayList<TextSegment> newItems = new ArrayList<TextSegment>();
        boolean merge = false;
        Iterator<? extends TextSegment> iter = textBlocks.iterator();
        while (iter.hasNext()) {
            TextSegment thisBlock = null;
            while (iter.hasNext() && (thisBlock == null || thisBlock.isEmpty())) {
                thisBlock = iter.next();
            }
            if (lastBlock != null) {
                if (LineProcessor.sameLine(lastBlock, thisBlock, maxX, postNG, ignoreFontsize)) {
                    if (merge) {
                        newItems.add(thisBlock);
                    } else {
                        newItems = new ArrayList();
                        newItems.add(thisBlock);
                        merge = true;
                    }
                } else {
                    CompositeSegment<TextSegment> newLine = new CompositeSegment<TextSegment>();
                    newLine.setItems(newItems);
                    newLine.setCalculatedFields();
                    retVal.add(newLine);
                    newItems = new ArrayList();
                    newItems.add(thisBlock);
                    merge = true;
                }
            } else {
                newItems = new ArrayList();
                newItems.add(thisBlock);
                merge = true;
            }
            lastBlock = thisBlock;
        }
        if (newItems.size() > 0) {
            CompositeSegment<TextSegment> newLine = new CompositeSegment<TextSegment>();
            newLine.setItems(newItems);
            newLine.setCalculatedFields();
            retVal.add(newLine);
        }
        return retVal;
    }

    private static boolean sameLine(TextSegment lastBlock, TextSegment thisBlock, float maxX, boolean postNG, boolean ignoreFontsize) {
        boolean xGuard;
        boolean sameFontSize;
        float fontSize;
        if (thisBlock.getX1() < lastBlock.getXmid()) {
            return false;
        }
        if (postNG) {
            return SegmentUtils.vertIntersect((GenericSegment)lastBlock, thisBlock.getYmid()) || SegmentUtils.vertIntersect((GenericSegment)thisBlock, lastBlock.getYmid());
        }
        if (lastBlock instanceof TextSegment && thisBlock instanceof TextSegment) {
            fontSize = (lastBlock.getFontSize() + thisBlock.getFontSize()) / 2.0f;
            sameFontSize = Utils.within(lastBlock.getFontSize(), thisBlock.getFontSize(), fontSize * 0.15f);
            xGuard = Utils.within(lastBlock.getX2(), thisBlock.getX1(), fontSize * maxX);
        } else {
            fontSize = -1.0f;
            sameFontSize = false;
            xGuard = false;
        }
        if (ignoreFontsize) {
            sameFontSize = true;
        }
        return Utils.within(lastBlock.getY1(), thisBlock.getY1(), fontSize * 0.3f) && sameFontSize && xGuard;
    }
}

