/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.analysis;

import jj2000.j2k.wavelet.analysis.AnWTFilterInt;

public class AnWTFilterIntLift5x3
extends AnWTFilterInt {
    private static final float[] LPSynthesisFilter = new float[]{0.5f, 1.0f, 0.5f};
    private static final float[] HPSynthesisFilter = new float[]{-0.125f, -0.25f, 0.75f, -0.25f, -0.125f};

    public void analyze_lpf(int[] inSig, int inOff, int inLen, int inStep, int[] lowSig, int lowOff, int lowStep, int[] highSig, int highOff, int highStep) {
        int i;
        int iStep = 2 * inStep;
        int ik = inOff + inStep;
        int hk = highOff;
        for (i = 1; i < inLen - 1; i += 2) {
            highSig[hk] = inSig[ik] - (inSig[ik - inStep] + inSig[ik + inStep] >> 1);
            ik += iStep;
            hk += highStep;
        }
        if (inLen % 2 == 0) {
            highSig[hk] = inSig[ik] - (2 * inSig[ik - inStep] >> 1);
        }
        ik = inOff;
        int lk = lowOff;
        hk = highOff;
        lowSig[lk] = inLen > 1 ? inSig[ik] + (highSig[hk] + 1 >> 1) : inSig[ik];
        ik += iStep;
        lk += lowStep;
        hk += highStep;
        for (i = 2; i < inLen - 1; i += 2) {
            lowSig[lk] = inSig[ik] + (highSig[hk - highStep] + highSig[hk] + 2 >> 2);
            ik += iStep;
            lk += lowStep;
            hk += highStep;
        }
        if (inLen % 2 == 1 && inLen > 2) {
            lowSig[lk] = inSig[ik] + (2 * highSig[hk - highStep] + 2 >> 2);
        }
    }

    public void analyze_hpf(int[] inSig, int inOff, int inLen, int inStep, int[] lowSig, int lowOff, int lowStep, int[] highSig, int highOff, int highStep) {
        int i;
        int iStep = 2 * inStep;
        int ik = inOff;
        int hk = highOff;
        highSig[hk] = inLen > 1 ? inSig[ik] - inSig[ik + inStep] : inSig[ik] << 1;
        ik += iStep;
        hk += highStep;
        if (inLen > 3) {
            for (i = 2; i < inLen - 1; i += 2) {
                highSig[hk] = inSig[ik] - (inSig[ik - inStep] + inSig[ik + inStep] >> 1);
                ik += iStep;
                hk += highStep;
            }
        }
        if (inLen % 2 == 1 && inLen > 1) {
            highSig[hk] = inSig[ik] - inSig[ik - inStep];
        }
        ik = inOff + inStep;
        int lk = lowOff;
        hk = highOff;
        for (i = 1; i < inLen - 1; i += 2) {
            lowSig[lk] = inSig[ik] + (highSig[hk] + highSig[hk + highStep] + 2 >> 2);
            ik += iStep;
            lk += lowStep;
            hk += highStep;
        }
        if (inLen > 1 && inLen % 2 == 0) {
            lowSig[lk] = inSig[ik] + (2 * highSig[hk] + 2 >> 2);
        }
    }

    public int getAnLowNegSupport() {
        return 2;
    }

    public int getAnLowPosSupport() {
        return 2;
    }

    public int getAnHighNegSupport() {
        return 1;
    }

    public int getAnHighPosSupport() {
        return 1;
    }

    public int getSynLowNegSupport() {
        return 1;
    }

    public int getSynLowPosSupport() {
        return 1;
    }

    public int getSynHighNegSupport() {
        return 2;
    }

    public int getSynHighPosSupport() {
        return 2;
    }

    public float[] getLPSynthesisFilter() {
        return LPSynthesisFilter;
    }

    public float[] getHPSynthesisFilter() {
        return HPSynthesisFilter;
    }

    public int getImplType() {
        return 0;
    }

    public boolean isReversible() {
        return true;
    }

    public boolean isSameAsFullWT(int tailOvrlp, int headOvrlp, int inLen) {
        if (inLen % 2 == 0) {
            return tailOvrlp >= 2 && headOvrlp >= 1;
        }
        return tailOvrlp >= 2 && headOvrlp >= 2;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof AnWTFilterIntLift5x3;
    }

    public int getFilterType() {
        return 1;
    }

    public String toString() {
        return "w5x3";
    }
}

