import java.io.*;

/*
 * FOS.java
 *
 */

/**
 *
 * This class class supplies simple file operation routines.
 *
 * @author  Olle Nebendahl
 */

class FOS
{
    private static int length = 1024;
  
    public static void setBufLength(int i){ length=i; }
    
    public String[] matchingFiles(String s)
    {
        return null;
    }
    
    public static void main(String[] args)
    {
        //System.out.println
        //writeToFile("FOStest.txt",readFromFileWithoutTexComments(args[0]));
        System.out.println(trimSlideCommand(args[1],args[0]));
    }
    
    public static String trimSlideCommand(String command, String s)
    {
        int pos = s.indexOf(command+" ");
        while(pos>-1)
        {
            s=s.substring(0,pos+command.length())+s.substring(pos+command.length()+1);
            pos = s.indexOf(command+" ");
        }
        return s;
    }
    
    public static String bracketsSave(String s)
    {
        return s.replaceAll("\\\\\\{","\\\"<replace this by an open accolade\\\">").replaceAll("\\\\\\}","\\\"<replace this by a closed accolade\\\">");
    }
    
    public static String bracketsUnSave(String s)
    {
        return s.replaceAll("\\\"<replace this by an open accolade\\\">","\\\\\\{").replaceAll("\\\"<replace this by a closed accolade\\\">","\\\\\\}");
    }
    
    public static String readFromFileWithoutTexComments(String fileName)
    // erstes % pro Zeile leitet eine Kommentierung ein, es sei denn vor dem 
    // % steht ein \, denn dann ist es ein Tex-%
    {
        try
        {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
        
            StringBuffer result=new StringBuffer();

            String zeile=in.readLine();
            String[] splitted;
            while(zeile!=null)
            {
                splitted=zeile.split("%",2);
                if(splitted.length>0)
                {
                    result.append(splitted[0]);
                    if(splitted.length>1)
                    {
                        //System.out.println(splitted[1]+" ## "+splitted[0].charAt(splitted[0].length()-1));
                        if(splitted[0].length()>1&&splitted[0].charAt(splitted[0].length()-1)=='\\')
                        {
                            result.append('%');
                            result.append(splitted[1]);
                            result.append('\n');
                        }
                        else result.append('\n');
                    }
                    else result.append('\n');
                }
                zeile=in.readLine();
            }
            in.close();
            return result.toString();
        }
        catch(java.io.IOException e){ System.out.println(e); System.out.println("FOS.readFromFileWithoutTexCommands");};
        return null;
    }


  public static String readFromFile(String fileName)
  {
    try
    {
        BufferedReader in = new BufferedReader(new FileReader(fileName));
    
        char[] bytes=new char[length];

        int zeichen=in.read(bytes);
        int total=zeichen;
        StringBuffer result=new StringBuffer();
        while(zeichen!=-1)
        {
            result.append(new String(bytes,0,zeichen));
            zeichen=in.read(bytes);
            total+=zeichen;
        }
        in.close();
        return result.toString();
    }
    catch(java.io.IOException e){ System.out.println(e); System.out.println("FOS.readFromFile");};
    return null;
  }

  static boolean writeToFile(String fileName, String content)
  {
    try
    {
        OutputStream out = new FileOutputStream(fileName);
        out.write( content.getBytes() );
        out.close();
        return true;
    }
    catch(java.io.IOException e){ System.out.println(e); System.out.println("FOS.writeToFile");};
    return false;
  }

  public static void miain(String[] args)
  {
     System.out.println(("setupdatabase.ddl;").split(";").length);
  }
  
  
  
}
