/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.data;

import com.izforge.izpack.api.data.DynamicInstallerRequirementValidator;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.api.rules.RulesEngine;
import java.io.Serializable;

public class DynamicInstallerRequirementValidatorImpl
implements DynamicInstallerRequirementValidator,
Serializable {
    private static final long serialVersionUID = -3752323264590369711L;
    private String conditionId;
    private DataValidator.Status severity;
    private String messageId;

    public DynamicInstallerRequirementValidatorImpl(String conditionId, DataValidator.Status severity, String messageId) {
        this.conditionId = conditionId;
        this.severity = severity;
        this.messageId = messageId;
    }

    @Override
    public DataValidator.Status validateData(InstallData idata) {
        RulesEngine rules = idata.getRules();
        if (!rules.isConditionTrue(this.conditionId)) {
            return this.severity;
        }
        return DataValidator.Status.OK;
    }

    @Override
    public String getErrorMessageId() {
        if (this.messageId != null) {
            return this.messageId;
        }
        return null;
    }

    @Override
    public String getWarningMessageId() {
        if (this.messageId != null) {
            return this.messageId;
        }
        return null;
    }

    @Override
    public boolean getDefaultAnswer() {
        return this.severity != DataValidator.Status.ERROR;
    }
}

