/*
 * error.h
 *
 * AUTHORS: Robert Fahy <rfahy@ymail.com>
 * CREDITS: n/a
 * VERSION: 1.00
 *
 */

/*
 * TASK:
 * - provides simplified error handling and printing macros so that the
 *  source code does not get polluted with error-checking `if' statements;
 *  in some cases you still have to use old-fashioned error handling though.
 *
 */

/*
 * TODO:
 * - assume wrong and check for OK at CHECK_ERROR?
 *
 */

#ifndef _ERROR_H_INCLUDED_
#define _ERROR_H_INCLUDED_

// standard include files
#include <stdlib.h>

// environment-specific include files
#include <errno.h>

// ABOUT: simplified calls to `print_error()'
#define PRINT_ERROR(...)			print_error(__FILE__, __LINE__, errno, __VA_ARGS__)
#define PRINT_ERROR_NOERRNO(...)	print_error(__FILE__, __LINE__, 0, __VA_ARGS__)

// declarations without definitions (aka prototypes)
void print_error(const char *filename, const int linenum, const int errnum, const char *fmt_message, ...);

#endif /* _ERROR_H_INCLUDED_ */
