/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;

public class SendAcknowledgementHandlerWrapper
implements SendAcknowledgementHandler {
    private SendAcknowledgementHandler wrapped;
    private volatile boolean active = true;

    public SendAcknowledgementHandlerWrapper(SendAcknowledgementHandler wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public void sendAcknowledged(Message message) {
        if (this.active) {
            try {
                this.wrapped.sendAcknowledged(message);
            }
            finally {
                this.active = false;
            }
        }
    }

    @Override
    public void sendFailed(Message message, Exception e) {
        if (this.active) {
            try {
                this.wrapped.sendFailed(message, e);
            }
            finally {
                this.active = false;
            }
        }
    }
}

