/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.parser.AbstractDataParser;
import org.apache.asterix.om.base.AUnorderedList;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.utils.RecordUtil;

public abstract class AbstractNestedDataParser<T>
extends AbstractDataParser {
    private T currentParsedToken;

    protected abstract void parseObject(ARecordType var1, DataOutput var2) throws IOException;

    protected abstract void parseArray(AOrderedListType var1, DataOutput var2) throws IOException;

    protected abstract void parseMultiset(AUnorderedList var1, DataOutput var2) throws IOException;

    protected abstract T advanceToNextToken() throws IOException;

    public final T nextToken() throws IOException {
        this.currentParsedToken = this.advanceToNextToken();
        return this.currentParsedToken;
    }

    public final T currentToken() {
        return this.currentParsedToken;
    }

    protected boolean isNullableType(IAType definedType) {
        if (definedType.getTypeTag() != ATypeTag.UNION) {
            return false;
        }
        return ((AUnionType)definedType).isNullableType();
    }

    protected boolean isMissableType(IAType definedType) {
        if (definedType.getTypeTag() != ATypeTag.UNION) {
            return false;
        }
        return ((AUnionType)definedType).isMissableType();
    }

    protected void checkOptionalConstraints(ARecordType recordType, BitSet nullBitmap) throws RuntimeDataException {
        for (int i = 0; i < recordType.getFieldTypes().length; ++i) {
            if (nullBitmap.get(i) || this.isMissableType(recordType.getFieldTypes()[i])) continue;
            throw new RuntimeDataException(3075, new Serializable[]{recordType.getFieldNames()[i]});
        }
    }

    protected IAType checkAndGetType(IAType definedType, ATypeTag parsedTypeTag) throws RuntimeDataException {
        if (parsedTypeTag == ATypeTag.NULL && this.isNullableType(definedType)) {
            return BuiltinType.ANULL;
        }
        IAType actualDefinedType = this.getActualType(definedType);
        if (actualDefinedType.getTypeTag() == ATypeTag.ANY) {
            switch (parsedTypeTag) {
                case OBJECT: {
                    return RecordUtil.FULLY_OPEN_RECORD_TYPE;
                }
                case ARRAY: {
                    return AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE;
                }
                case MULTISET: {
                    return AUnorderedListType.FULLY_OPEN_UNORDEREDLIST_TYPE;
                }
            }
            return BuiltinType.ANY;
        }
        if (actualDefinedType.getTypeTag() == parsedTypeTag || this.isConvertable(parsedTypeTag, actualDefinedType.getTypeTag())) {
            return actualDefinedType;
        }
        throw new RuntimeDataException(3054, new Serializable[]{definedType.getTypeName()});
    }

    private IAType getActualType(IAType definedType) {
        if (definedType.getTypeTag() == ATypeTag.UNION) {
            return ((AUnionType)definedType).getActualType();
        }
        return definedType;
    }

    protected boolean isConvertable(ATypeTag parsedTypeTag, ATypeTag definedTypeTag) {
        boolean convertable = parsedTypeTag == ATypeTag.STRING;
        return (convertable &= definedTypeTag == ATypeTag.UUID || definedTypeTag == ATypeTag.DATE || definedTypeTag == ATypeTag.TIME || definedTypeTag == ATypeTag.DATETIME) || ATypeHierarchy.canPromote((ATypeTag)parsedTypeTag, (ATypeTag)definedTypeTag) || ATypeHierarchy.canDemote((ATypeTag)parsedTypeTag, (ATypeTag)definedTypeTag);
    }
}

