/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.IDatasetDetails;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ADateTime;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.AUnorderedList;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class DatasetTupleTranslator
extends AbstractTupleTranslator<Dataset> {
    private static final int DATASET_PAYLOAD_TUPLE_FIELD_INDEX = 2;
    protected AMutableInt32 aInt32;
    protected AMutableInt64 aInt64;

    protected DatasetTupleTranslator(boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.DATASET_DATASET, 2);
        if (getTuple) {
            this.aInt32 = new AMutableInt32(-1);
            this.aInt64 = new AMutableInt64(-1L);
        }
    }

    @Override
    protected Dataset createMetadataEntityFromARecord(ARecord datasetRecord) throws AlgebricksException {
        String dataverseCanonicalName = ((AString)datasetRecord.getValueByPos(0)).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        String datasetName = ((AString)datasetRecord.getValueByPos(1)).getStringValue();
        String typeName = ((AString)datasetRecord.getValueByPos(3)).getStringValue();
        String typeDataverseCanonicalName = ((AString)datasetRecord.getValueByPos(2)).getStringValue();
        DataverseName typeDataverseName = DataverseName.createFromCanonicalForm((String)typeDataverseCanonicalName);
        DatasetConfig.DatasetType datasetType = DatasetConfig.DatasetType.valueOf((String)((AString)datasetRecord.getValueByPos(4)).getStringValue());
        IDatasetDetails datasetDetails = null;
        int datasetId = ((AInt32)datasetRecord.getValueByPos(12)).getIntegerValue();
        int pendingOp = ((AInt32)datasetRecord.getValueByPos(13)).getIntegerValue();
        String nodeGroupName = ((AString)datasetRecord.getValueByPos(5)).getStringValue();
        Pair<String, Map<String, String>> compactionPolicy = this.readCompactionPolicy(datasetType, datasetRecord);
        switch (datasetType) {
            case INTERNAL: {
                ARecord datasetDetailsRecord = (ARecord)datasetRecord.getValueByPos(8);
                InternalDatasetDetails.FileStructure fileStructure = InternalDatasetDetails.FileStructure.valueOf(((AString)datasetDetailsRecord.getValueByPos(0)).getStringValue());
                InternalDatasetDetails.PartitioningStrategy partitioningStrategy = InternalDatasetDetails.PartitioningStrategy.valueOf(((AString)datasetDetailsRecord.getValueByPos(1)).getStringValue());
                IACursor cursor = ((AOrderedList)datasetDetailsRecord.getValueByPos(2)).getCursor();
                ArrayList<List<String>> partitioningKey = new ArrayList<List<String>>();
                ArrayList<IAType> partitioningKeyType = new ArrayList<IAType>();
                while (cursor.next()) {
                    AOrderedList fieldNameList = (AOrderedList)cursor.get();
                    IACursor nestedFieldNameCursor = fieldNameList.getCursor();
                    ArrayList<String> nestedFieldName = new ArrayList<String>();
                    while (nestedFieldNameCursor.next()) {
                        nestedFieldName.add(((AString)nestedFieldNameCursor.get()).getStringValue());
                    }
                    partitioningKey.add(nestedFieldName);
                    partitioningKeyType.add((IAType)BuiltinType.ASTRING);
                }
                boolean autogenerated = ((ABoolean)datasetDetailsRecord.getValueByPos(4)).getBoolean();
                Integer filterSourceIndicator = null;
                int filterSourceIndicatorPos = datasetDetailsRecord.getType().getFieldIndex("FilterSourceIndicator");
                if (filterSourceIndicatorPos >= 0) {
                    filterSourceIndicator = ((AInt8)datasetDetailsRecord.getValueByPos(filterSourceIndicatorPos)).getByteValue();
                }
                ArrayList<String> filterField = null;
                int filterFieldPos = datasetDetailsRecord.getType().getFieldIndex("FilterField");
                if (filterFieldPos >= 0) {
                    if (filterSourceIndicator == null) {
                        filterSourceIndicator = 0;
                    }
                    filterField = new ArrayList<String>();
                    cursor = ((AOrderedList)datasetDetailsRecord.getValueByPos(filterFieldPos)).getCursor();
                    while (cursor.next()) {
                        filterField.add(((AString)cursor.get()).getStringValue());
                    }
                }
                ArrayList<Integer> keyFieldSourceIndicator = new ArrayList<Integer>();
                int keyFieldSourceIndicatorIndex = datasetDetailsRecord.getType().getFieldIndex("KeySourceIndicator");
                if (keyFieldSourceIndicatorIndex >= 0) {
                    cursor = ((AOrderedList)datasetDetailsRecord.getValueByPos(keyFieldSourceIndicatorIndex)).getCursor();
                    while (cursor.next()) {
                        keyFieldSourceIndicator.add(Integer.valueOf(((AInt8)cursor.get()).getByteValue()));
                    }
                } else {
                    for (int index = 0; index < partitioningKey.size(); ++index) {
                        keyFieldSourceIndicator.add(0);
                    }
                }
                datasetDetails = new InternalDatasetDetails(fileStructure, partitioningStrategy, partitioningKey, partitioningKey, keyFieldSourceIndicator, partitioningKeyType, autogenerated, filterSourceIndicator, filterField);
                break;
            }
            case EXTERNAL: {
                ARecord datasetDetailsRecord = (ARecord)datasetRecord.getValueByPos(9);
                String adapter = ((AString)datasetDetailsRecord.getValueByPos(0)).getStringValue();
                IACursor cursor = ((AOrderedList)datasetDetailsRecord.getValueByPos(1)).getCursor();
                HashMap<String, String> properties = new HashMap<String, String>();
                while (cursor.next()) {
                    ARecord field = (ARecord)cursor.get();
                    String key = ((AString)field.getValueByPos(0)).getStringValue();
                    String value = ((AString)field.getValueByPos(1)).getStringValue();
                    properties.put(key, value);
                }
                Date timestamp = new Date(((ADateTime)datasetDetailsRecord.getValueByPos(2)).getChrononTime());
                DatasetConfig.TransactionState state = DatasetConfig.TransactionState.values()[((AInt32)datasetDetailsRecord.getValueByPos(3)).getIntegerValue()];
                datasetDetails = new ExternalDatasetDetails(adapter, properties, timestamp, state);
            }
        }
        Map<String, String> hints = this.getDatasetHints(datasetRecord);
        DataverseName metaTypeDataverseName = null;
        String metaTypeName = null;
        int metaTypeDataverseNameIndex = datasetRecord.getType().getFieldIndex("MetatypeDataverseName");
        if (metaTypeDataverseNameIndex >= 0) {
            String metaTypeDataverseCanonicalName = ((AString)datasetRecord.getValueByPos(metaTypeDataverseNameIndex)).getStringValue();
            metaTypeDataverseName = DataverseName.createFromCanonicalForm((String)metaTypeDataverseCanonicalName);
            int metaTypeNameIndex = datasetRecord.getType().getFieldIndex("MetatypeName");
            metaTypeName = ((AString)datasetRecord.getValueByPos(metaTypeNameIndex)).getStringValue();
        }
        long rebalanceCount = this.getRebalanceCount(datasetRecord);
        String compressionScheme = this.getCompressionScheme(datasetRecord);
        return new Dataset(dataverseName, datasetName, typeDataverseName, typeName, metaTypeDataverseName, metaTypeName, nodeGroupName, (String)compactionPolicy.first, (Map)compactionPolicy.second, datasetDetails, hints, datasetType, datasetId, pendingOp, rebalanceCount, compressionScheme);
    }

    protected Pair<String, Map<String, String>> readCompactionPolicy(DatasetConfig.DatasetType datasetType, ARecord datasetRecord) {
        Map<String, String> compactionPolicyProperties;
        String compactionPolicy = ((AString)datasetRecord.getValueByPos(6)).getStringValue();
        AOrderedList compactionPolicyPropertiesList = (AOrderedList)datasetRecord.getValueByPos(7);
        if (compactionPolicyPropertiesList.size() > 0) {
            compactionPolicyProperties = new LinkedHashMap();
            IACursor cursor = compactionPolicyPropertiesList.getCursor();
            while (cursor.next()) {
                ARecord field = (ARecord)cursor.get();
                String key = ((AString)field.getValueByPos(0)).getStringValue();
                String value = ((AString)field.getValueByPos(1)).getStringValue();
                compactionPolicyProperties.put(key, value);
            }
        } else {
            compactionPolicyProperties = Collections.emptyMap();
        }
        return new Pair((Object)compactionPolicy, compactionPolicyProperties);
    }

    private long getRebalanceCount(ARecord datasetRecord) {
        int rebalanceCountIndex = datasetRecord.getType().getFieldIndex("rebalanceCount");
        return rebalanceCountIndex >= 0 ? ((AInt64)datasetRecord.getValueByPos(rebalanceCountIndex)).getLongValue() : 0L;
    }

    private String getCompressionScheme(ARecord datasetRecord) {
        ARecordType datasetType = datasetRecord.getType();
        int compressionIndex = datasetType.getFieldIndex("BlockLevelStorageCompression");
        if (compressionIndex >= 0) {
            ARecordType compressionType = (ARecordType)datasetType.getFieldTypes()[compressionIndex];
            int schemeIndex = compressionType.getFieldIndex("DatasetCompressionScheme");
            ARecord compressionRecord = (ARecord)datasetRecord.getValueByPos(compressionIndex);
            return ((AString)compressionRecord.getValueByPos(schemeIndex)).getStringValue();
        }
        return "none";
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Dataset dataset) throws HyracksDataException {
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        String dataverseCanonicalName = dataset.getDataverseName().getCanonicalForm();
        this.tupleBuilder.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(dataset.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.DATASET_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataset.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataset.getItemTypeDataverseName().getCanonicalForm());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataset.getItemTypeName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataset.getDatasetType().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(4, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataset.getNodeGroupName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(5, (IValueReference)this.fieldValue);
        this.writeCompactionPolicy(dataset.getDatasetType(), dataset.getCompactionPolicy(), dataset.getCompactionPolicyProperties(), listBuilder, itemValue);
        this.fieldValue.reset();
        this.writeDatasetDetailsRecordType(this.recordBuilder, dataset, this.fieldValue.getDataOutput());
        UnorderedListBuilder uListBuilder = new UnorderedListBuilder();
        uListBuilder.reset((AbstractCollectionType)((AUnorderedListType)MetadataRecordTypes.DATASET_RECORDTYPE.getFieldTypes()[10]));
        for (Map.Entry<String, String> property : dataset.getHints().entrySet()) {
            String name = property.getKey();
            String value = property.getValue();
            itemValue.reset();
            this.writeDatasetHintRecord(name, value, itemValue.getDataOutput());
            uListBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        uListBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(10, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(11, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aInt32.setValue(dataset.getDatasetId());
        this.int32Serde.serialize((Object)this.aInt32, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(12, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aInt32.setValue(dataset.getPendingOp());
        this.int32Serde.serialize((Object)this.aInt32, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(13, (IValueReference)this.fieldValue);
        this.writeOpenFields(dataset);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    protected void writeCompactionPolicy(DatasetConfig.DatasetType datasetType, String compactionPolicy, Map<String, String> compactionPolicyProperties, OrderedListBuilder listBuilder, ArrayBackedValueStorage itemValue) throws HyracksDataException {
        this.fieldValue.reset();
        this.aString.setValue(compactionPolicy);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(6, (IValueReference)this.fieldValue);
        listBuilder.reset((AbstractCollectionType)((AOrderedListType)MetadataRecordTypes.DATASET_RECORDTYPE.getFieldTypes()[7]));
        if (compactionPolicyProperties != null && !compactionPolicyProperties.isEmpty()) {
            for (Map.Entry<String, String> property : compactionPolicyProperties.entrySet()) {
                String name = property.getKey();
                String value = property.getValue();
                itemValue.reset();
                DatasetUtil.writePropertyTypeRecord(name, value, itemValue.getDataOutput(), MetadataRecordTypes.COMPACTION_POLICY_PROPERTIES_RECORDTYPE);
                listBuilder.addItem((IValueReference)itemValue);
            }
        }
        this.fieldValue.reset();
        listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(7, (IValueReference)this.fieldValue);
    }

    protected void writeOpenFields(Dataset dataset) throws HyracksDataException {
        this.writeMetaPart(dataset);
        this.writeRebalanceCount(dataset);
        this.writeBlockLevelStorageCompression(dataset);
    }

    private void writeMetaPart(Dataset dataset) throws HyracksDataException {
        if (dataset.hasMetaPart()) {
            this.fieldName.reset();
            this.aString.setValue("MetatypeDataverseName");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aString.setValue(dataset.getMetaItemTypeDataverseName().getCanonicalForm());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
            this.fieldName.reset();
            this.aString.setValue("MetatypeName");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aString.setValue(dataset.getMetaItemTypeName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
    }

    private void writeBlockLevelStorageCompression(Dataset dataset) throws HyracksDataException {
        if ("none".equals(dataset.getCompressionScheme())) {
            return;
        }
        RecordBuilder compressionObject = new RecordBuilder();
        compressionObject.reset(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        this.fieldName.reset();
        this.aString.setValue("DatasetCompressionScheme");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(dataset.getCompressionScheme());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        compressionObject.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        this.fieldName.reset();
        this.aString.setValue("BlockLevelStorageCompression");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        compressionObject.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    private void writeRebalanceCount(Dataset dataset) throws HyracksDataException {
        if (dataset.getRebalanceCount() > 0L) {
            this.fieldName.reset();
            this.aString.setValue("rebalanceCount");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aInt64.setValue(dataset.getRebalanceCount());
            this.int64Serde.serialize((Object)this.aInt64, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
    }

    protected void writeDatasetDetailsRecordType(IARecordBuilder recordBuilder, Dataset dataset, DataOutput dataOutput) throws HyracksDataException {
        dataset.getDatasetDetails().writeDatasetDetailsRecordType(dataOutput);
        switch (dataset.getDatasetType()) {
            case INTERNAL: {
                recordBuilder.addField(8, (IValueReference)this.fieldValue);
                break;
            }
            case EXTERNAL: {
                recordBuilder.addField(9, (IValueReference)this.fieldValue);
            }
        }
    }

    protected Map<String, String> getDatasetHints(ARecord datasetRecord) {
        HashMap<String, String> hints = new HashMap<String, String>();
        AUnorderedList list = (AUnorderedList)datasetRecord.getValueByPos(10);
        IACursor cursor = list.getCursor();
        while (cursor.next()) {
            ARecord field = (ARecord)cursor.get();
            String key = ((AString)field.getValueByPos(0)).getStringValue();
            String value = ((AString)field.getValueByPos(1)).getStringValue();
            hints.put(key, value);
        }
        return hints;
    }

    protected void writeDatasetHintRecord(String name, String value, DataOutput out) throws HyracksDataException {
        RecordBuilder propertyRecordBuilder = new RecordBuilder();
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        propertyRecordBuilder.reset(MetadataRecordTypes.DATASET_HINTS_RECORDTYPE);
        AMutableString aString = new AMutableString("");
        fieldValue.reset();
        aString.setValue(name);
        this.stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(0, (IValueReference)fieldValue);
        fieldValue.reset();
        aString.setValue(value);
        this.stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(1, (IValueReference)fieldValue);
        propertyRecordBuilder.write(out, true);
    }
}

