/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.credential;

import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;

public final class AzureSasCredential {
    private final ClientLogger logger = new ClientLogger(AzureSasCredential.class);
    private volatile String signature;

    public AzureSasCredential(String signature) {
        Objects.requireNonNull(signature, "'signature' cannot be null.");
        if (signature.isEmpty()) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("'signature' cannot be empty."));
        }
        this.signature = signature;
    }

    public String getSignature() {
        return this.signature;
    }

    public AzureSasCredential update(String signature) {
        Objects.requireNonNull(signature, "'signature' cannot be null.");
        if (signature.isEmpty()) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("'signature' cannot be empty."));
        }
        this.signature = signature;
        return this;
    }
}

