/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.IndexedTypeExpression;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class CreateIndexStatement
extends AbstractStatement {
    private final DataverseName dataverseName;
    private final Identifier datasetName;
    private final Identifier indexName;
    private final DatasetConfig.IndexType indexType;
    private final List<IndexedElement> indexedElements;
    private final boolean enforced;
    private final boolean ifNotExists;
    private final int gramLength;
    private final String fullTextConfigName;

    public CreateIndexStatement(DataverseName dataverseName, Identifier datasetName, Identifier indexName, DatasetConfig.IndexType indexType, List<IndexedElement> indexedElements, boolean enforced, int gramLength, String fullTextConfigName, boolean ifNotExists) {
        this.dataverseName = dataverseName;
        this.datasetName = Objects.requireNonNull(datasetName);
        this.indexName = Objects.requireNonNull(indexName);
        this.indexType = Objects.requireNonNull(indexType);
        this.indexedElements = Objects.requireNonNull(indexedElements);
        this.enforced = enforced;
        this.gramLength = gramLength;
        this.ifNotExists = ifNotExists;
        this.fullTextConfigName = fullTextConfigName;
    }

    public String getFullTextConfigName() {
        return this.fullTextConfigName;
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    public Identifier getDatasetName() {
        return this.datasetName;
    }

    public Identifier getIndexName() {
        return this.indexName;
    }

    public DatasetConfig.IndexType getIndexType() {
        return this.indexType;
    }

    public List<IndexedElement> getIndexedElements() {
        return this.indexedElements;
    }

    public boolean isEnforced() {
        return this.enforced;
    }

    public int getGramLength() {
        return this.gramLength;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.CREATE_INDEX;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    @Override
    public byte getCategory() {
        return 4;
    }

    public static final class IndexedElement {
        private final int sourceIndicator;
        private final List<List<String>> unnestList;
        private final List<Pair<List<String>, IndexedTypeExpression>> projectList;
        private SourceLocation sourceLoc;

        public IndexedElement(int sourceIndicator, List<List<String>> unnestList, List<Pair<List<String>, IndexedTypeExpression>> projectList) {
            if (Objects.requireNonNull(projectList).isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.sourceIndicator = sourceIndicator;
            this.unnestList = unnestList != null ? unnestList : Collections.emptyList();
            this.projectList = projectList;
        }

        public int getSourceIndicator() {
            return this.sourceIndicator;
        }

        public boolean hasUnnest() {
            return !this.unnestList.isEmpty();
        }

        public List<List<String>> getUnnestList() {
            return this.unnestList;
        }

        public List<Pair<List<String>, IndexedTypeExpression>> getProjectList() {
            return this.projectList;
        }

        public Triple<Integer, List<List<String>>, List<List<String>>> toIdentifier() {
            List newProjectList = this.projectList.stream().map(Pair::getFirst).collect(Collectors.toList());
            return new Triple((Object)this.sourceIndicator, this.unnestList, newProjectList);
        }

        public SourceLocation getSourceLocation() {
            return this.sourceLoc;
        }

        public void setSourceLocation(SourceLocation sourceLoc) {
            this.sourceLoc = sourceLoc;
        }

        public String getProjectListDisplayForm() {
            return this.projectList.stream().map(Pair::getFirst).map(String::valueOf).collect(Collectors.joining(", "));
        }
    }
}

