/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types;

import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;

public class TypeHelper {
    private TypeHelper() {
    }

    public static boolean canBeMissing(IAType t) {
        switch (t.getTypeTag()) {
            case MISSING: {
                return true;
            }
            case UNION: {
                return ((AUnionType)t).isMissableType();
            }
        }
        return false;
    }

    public static boolean canBeUnknown(IAType t) {
        switch (t.getTypeTag()) {
            case MISSING: 
            case NULL: 
            case ANY: {
                return true;
            }
            case UNION: {
                return ((AUnionType)t).isUnknownableType();
            }
        }
        return false;
    }

    public static boolean isClosed(IAType t) {
        switch (t.getTypeTag()) {
            case MISSING: 
            case ANY: {
                return false;
            }
            case UNION: {
                return TypeHelper.isClosed(((AUnionType)t).getActualType());
            }
        }
        return true;
    }

    public static boolean isFullyOpen(IAType type) {
        IAType actualType = TypeComputeUtils.getActualType(type);
        switch (actualType.getTypeTag()) {
            case OBJECT: {
                ARecordType recordType = (ARecordType)actualType;
                return recordType.getFieldNames().length == 0 && recordType.isOpen();
            }
            case ARRAY: 
            case MULTISET: {
                AbstractCollectionType collectionType = (AbstractCollectionType)actualType;
                return TypeComputeUtils.getActualType(collectionType.getItemType()).getTypeTag() == ATypeTag.ANY;
            }
            case ANY: {
                return true;
            }
        }
        if (actualType.getTypeTag().isDerivedType()) {
            throw new NotImplementedException();
        }
        return true;
    }
}

