/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.job;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IWritable;

public final class DeployedJobSpecId
implements IWritable,
Serializable {
    public static final DeployedJobSpecId INVALID = new DeployedJobSpecId(-1L);
    private static final long serialVersionUID = 1L;
    private long id;

    public static DeployedJobSpecId create(DataInput dis) throws IOException {
        DeployedJobSpecId deployedJobSpecId = new DeployedJobSpecId();
        deployedJobSpecId.readFields(dis);
        return deployedJobSpecId;
    }

    private DeployedJobSpecId() {
    }

    public DeployedJobSpecId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeployedJobSpecId)) {
            return false;
        }
        return ((DeployedJobSpecId)o).id == this.id;
    }

    public String toString() {
        return "PDJID:" + this.id;
    }

    public static DeployedJobSpecId parse(String str) throws HyracksDataException {
        if (str.startsWith("PDJID:")) {
            return new DeployedJobSpecId(Long.parseLong(str.substring(4)));
        }
        throw HyracksDataException.create(ErrorCode.NOT_A_JOBID, new Serializable[]{str});
    }

    @Override
    public void writeFields(DataOutput output) throws IOException {
        output.writeLong(this.id);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.id = input.readLong();
    }
}

