/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.typeinfo;

import java.math.BigDecimal;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;

public class HiveDecimalUtils {
    public static HiveDecimal enforcePrecisionScale(HiveDecimal dec, DecimalTypeInfo typeInfo) {
        return HiveDecimalUtils.enforcePrecisionScale(dec, typeInfo.precision(), typeInfo.scale());
    }

    public static HiveDecimal enforcePrecisionScale(HiveDecimal dec, int maxPrecision, int maxScale) {
        if (dec == null) {
            return null;
        }
        if (dec.precision() - dec.scale() <= maxPrecision - maxScale && dec.scale() <= maxScale) {
            return dec;
        }
        BigDecimal bd = HiveDecimal.enforcePrecisionScale((BigDecimal)dec.bigDecimalValue(), (int)maxPrecision, (int)maxScale);
        if (bd == null) {
            return null;
        }
        return HiveDecimal.create((BigDecimal)bd);
    }

    public static HiveDecimalWritable enforcePrecisionScale(HiveDecimalWritable writable, DecimalTypeInfo typeInfo) {
        if (writable == null) {
            return null;
        }
        HiveDecimal dec = HiveDecimalUtils.enforcePrecisionScale(writable.getHiveDecimal(), typeInfo);
        return dec == null ? null : new HiveDecimalWritable(dec);
    }

    public static HiveDecimalWritable enforcePrecisionScale(HiveDecimalWritable writable, int precision, int scale) {
        if (writable == null) {
            return null;
        }
        HiveDecimal dec = HiveDecimalUtils.enforcePrecisionScale(writable.getHiveDecimal(), precision, scale);
        return dec == null ? null : new HiveDecimalWritable(dec);
    }

    public static void validateParameter(int precision, int scale) {
        if (precision < 1 || precision > 38) {
            throw new IllegalArgumentException("Decimal precision out of allowed range [1,38]");
        }
        if (scale < 0 || scale > 38) {
            throw new IllegalArgumentException("Decimal scale out of allowed range [0,38]");
        }
        if (precision < scale) {
            throw new IllegalArgumentException("Decimal scale must be less than or equal to precision");
        }
    }

    public static int getPrecisionForType(PrimitiveTypeInfo typeInfo) {
        switch (typeInfo.getPrimitiveCategory()) {
            case DECIMAL: {
                return ((DecimalTypeInfo)typeInfo).precision();
            }
            case FLOAT: {
                return 7;
            }
            case DOUBLE: {
                return 15;
            }
            case BYTE: {
                return 3;
            }
            case SHORT: {
                return 5;
            }
            case INT: {
                return 10;
            }
            case LONG: {
                return 19;
            }
            case VOID: {
                return 1;
            }
        }
        return 38;
    }

    public static int getScaleForType(PrimitiveTypeInfo typeInfo) {
        switch (typeInfo.getPrimitiveCategory()) {
            case DECIMAL: {
                return ((DecimalTypeInfo)typeInfo).scale();
            }
            case FLOAT: {
                return 7;
            }
            case DOUBLE: {
                return 15;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case VOID: {
                return 0;
            }
        }
        return 38;
    }
}

