/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.impls;

import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingFrameTupleReference;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public class BatchPredicate
extends RangePredicate {
    private static final long serialVersionUID = 1L;
    protected final FrameTupleReference keyTuple;
    protected final FrameTupleReference minFilterTuple;
    protected final FrameTupleReference maxFilterTuple;
    protected int keyIndex = 0;
    protected IFrameTupleAccessor accessor;

    public BatchPredicate(IFrameTupleAccessor accessor, MultiComparator keyCmp, int[] keyFields, int[] minFilterKeyFields, int[] maxFieldKeyFields) {
        super(null, null, true, true, keyCmp, keyCmp);
        this.accessor = accessor;
        this.keyTuple = keyFields != null && keyFields.length > 0 ? new PermutingFrameTupleReference(keyFields) : new FrameTupleReference();
        this.minFilterTuple = minFilterKeyFields != null && minFilterKeyFields.length > 0 ? new PermutingFrameTupleReference(minFilterKeyFields) : null;
        this.maxFilterTuple = maxFieldKeyFields != null && maxFieldKeyFields.length > 0 ? new PermutingFrameTupleReference(maxFieldKeyFields) : null;
    }

    public void reset(IFrameTupleAccessor accessor) {
        this.keyIndex = -1;
        this.accessor = accessor;
    }

    private boolean isValid() {
        return this.accessor != null && this.keyIndex >= 0 && this.keyIndex < this.accessor.getTupleCount();
    }

    @Override
    public ITupleReference getLowKey() {
        return this.isValid() ? this.keyTuple : null;
    }

    @Override
    public ITupleReference getHighKey() {
        return this.isValid() ? this.keyTuple : null;
    }

    public ITupleReference getMinFilterTuple() {
        return this.isValid() ? this.minFilterTuple : null;
    }

    public ITupleReference getMaxFilterTuple() {
        return this.isValid() ? this.maxFilterTuple : null;
    }

    @Override
    public boolean isPointPredicate(MultiComparator originalKeyComparator) throws HyracksDataException {
        return true;
    }

    public boolean hasNext() {
        return this.accessor != null && this.keyIndex < this.accessor.getTupleCount() - 1;
    }

    public void next() {
        ++this.keyIndex;
        if (this.isValid()) {
            this.keyTuple.reset(this.accessor, this.keyIndex);
            if (this.minFilterTuple != null) {
                this.minFilterTuple.reset(this.accessor, this.keyIndex);
            }
            if (this.maxFilterTuple != null) {
                this.maxFilterTuple.reset(this.accessor, this.keyIndex);
            }
        }
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    public int getNumKeys() {
        return this.accessor.getTupleCount();
    }
}

