/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.shutdown.ShutdownRun;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NotifyShutdownWork
extends SynchronizableWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClusterControllerService ccs;
    private final String nodeId;

    public NotifyShutdownWork(ClusterControllerService ccs, String nodeId) {
        this.ccs = ccs;
        this.nodeId = nodeId;
    }

    public void doRun() {
        ShutdownRun sRun = this.ccs.getShutdownRun();
        if (sRun != null) {
            LOGGER.info("Received shutdown acknowledgement from node " + this.nodeId);
            sRun.notifyShutdown(this.nodeId);
        } else {
            LOGGER.info("Received unsolicted shutdown notification from node " + this.nodeId);
        }
    }
}

