/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.object.base;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.object.base.AdmBooleanNode;
import org.apache.asterix.object.base.AdmNullNode;
import org.apache.asterix.object.base.IAdmNode;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class AdmArrayNode
implements IAdmNode,
Iterable<IAdmNode> {
    private static final long serialVersionUID = 1L;
    private final List<IAdmNode> children;

    public AdmArrayNode() {
        this.children = new ArrayList<IAdmNode>();
    }

    public AdmArrayNode(int initialCapacity) {
        this.children = new ArrayList<IAdmNode>(initialCapacity);
    }

    public IAdmNode set(int index, boolean value) {
        return this.set(index, AdmBooleanNode.get(value));
    }

    public void add(boolean value) {
        this.add(AdmBooleanNode.get(value));
    }

    public int size() {
        return this.children.size();
    }

    public void add(IAdmNode value) {
        if (value == null) {
            value = AdmNullNode.INSTANCE;
        }
        this.children.add(value);
    }

    public IAdmNode set(int index, IAdmNode value) {
        if (value == null) {
            value = AdmNullNode.INSTANCE;
        }
        return this.children.set(index, value);
    }

    public IAdmNode get(int index) {
        return this.children.get(index);
    }

    @Override
    public ATypeTag getType() {
        return ATypeTag.ARRAY;
    }

    @Override
    public void reset() {
        this.children.clear();
    }

    public String toString() {
        return this.children.toString();
    }

    @Override
    public void serializeValue(DataOutput dataOutput) throws IOException {
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        listBuilder.reset(AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        for (int i = 0; i < this.children.size(); ++i) {
            itemValue.reset();
            IAdmNode next = this.children.get(i);
            next.serialize(itemValue.getDataOutput());
            listBuilder.addItem((IValueReference)itemValue);
        }
        listBuilder.write(dataOutput, false);
    }

    @Override
    public Iterator<IAdmNode> iterator() {
        return this.children.iterator();
    }
}

