/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.ipc.impl;

import java.net.URL;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.api.client.ClusterControllerInfo;
import org.apache.hyracks.api.client.HyracksClientInterfaceFunctions;
import org.apache.hyracks.api.client.IHyracksClientInterface;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.job.DeployedJobSpecId;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobInfo;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.api.topology.ClusterTopology;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.api.RPCInterface;
import org.apache.hyracks.ipc.exceptions.IPCException;

public class HyracksClientInterfaceRemoteProxy
implements IHyracksClientInterface {
    private static final int SHUTDOWN_CONNECTION_TIMEOUT_SECS = 30;
    private final IIPCHandle ipcHandle;
    private final RPCInterface rpci;

    public HyracksClientInterfaceRemoteProxy(IIPCHandle ipcHandle, RPCInterface rpci) {
        this.ipcHandle = ipcHandle;
        this.rpci = rpci;
    }

    public ClusterControllerInfo getClusterControllerInfo() throws Exception {
        HyracksClientInterfaceFunctions.GetClusterControllerInfoFunction gccif = new HyracksClientInterfaceFunctions.GetClusterControllerInfoFunction();
        return (ClusterControllerInfo)this.rpci.call(this.ipcHandle, gccif);
    }

    public JobStatus getJobStatus(JobId jobId) throws Exception {
        HyracksClientInterfaceFunctions.GetJobStatusFunction gjsf = new HyracksClientInterfaceFunctions.GetJobStatusFunction(jobId);
        return (JobStatus)this.rpci.call(this.ipcHandle, gjsf);
    }

    public JobId startJob(byte[] acggfBytes, EnumSet<JobFlag> jobFlags) throws Exception {
        HyracksClientInterfaceFunctions.StartJobFunction sjf = new HyracksClientInterfaceFunctions.StartJobFunction(acggfBytes, jobFlags);
        return (JobId)this.rpci.call(this.ipcHandle, sjf);
    }

    public void cancelJob(JobId jobId) throws Exception {
        HyracksClientInterfaceFunctions.CancelJobFunction cjf = new HyracksClientInterfaceFunctions.CancelJobFunction(jobId);
        this.rpci.call(this.ipcHandle, cjf);
    }

    public JobId startJob(DeployedJobSpecId deployedJobSpecId, Map<byte[], byte[]> jobParameters) throws Exception {
        HyracksClientInterfaceFunctions.StartJobFunction sjf = new HyracksClientInterfaceFunctions.StartJobFunction(deployedJobSpecId, jobParameters);
        return (JobId)this.rpci.call(this.ipcHandle, sjf);
    }

    public JobId startJob(DeploymentId deploymentId, byte[] acggfBytes, EnumSet<JobFlag> jobFlags) throws Exception {
        HyracksClientInterfaceFunctions.StartJobFunction sjf = new HyracksClientInterfaceFunctions.StartJobFunction(deploymentId, acggfBytes, jobFlags);
        return (JobId)this.rpci.call(this.ipcHandle, sjf);
    }

    public DeployedJobSpecId deployJobSpec(byte[] acggfBytes) throws Exception {
        HyracksClientInterfaceFunctions.DeployJobSpecFunction sjf = new HyracksClientInterfaceFunctions.DeployJobSpecFunction(acggfBytes);
        return (DeployedJobSpecId)this.rpci.call(this.ipcHandle, sjf);
    }

    public void redeployJobSpec(DeployedJobSpecId deployedJobSpecId, byte[] acggfBytes) throws Exception {
        HyracksClientInterfaceFunctions.redeployJobSpecFunction udjsf = new HyracksClientInterfaceFunctions.redeployJobSpecFunction(deployedJobSpecId, acggfBytes);
        this.rpci.call(this.ipcHandle, udjsf);
    }

    public void undeployJobSpec(DeployedJobSpecId deployedJobSpecId) throws Exception {
        HyracksClientInterfaceFunctions.UndeployJobSpecFunction sjf = new HyracksClientInterfaceFunctions.UndeployJobSpecFunction(deployedJobSpecId);
        this.rpci.call(this.ipcHandle, sjf);
    }

    public NetworkAddress getResultDirectoryAddress() throws Exception {
        HyracksClientInterfaceFunctions.GetResultDirectoryAddressFunction gddsf = new HyracksClientInterfaceFunctions.GetResultDirectoryAddressFunction();
        return (NetworkAddress)this.rpci.call(this.ipcHandle, gddsf);
    }

    public void waitForCompletion(JobId jobId) throws Exception {
        HyracksClientInterfaceFunctions.WaitForCompletionFunction wfcf = new HyracksClientInterfaceFunctions.WaitForCompletionFunction(jobId);
        this.rpci.call(this.ipcHandle, wfcf);
    }

    public List<IOperatorStats> waitForCompletion(JobId jobId, List<String> statOperatorNames) throws Exception {
        HyracksClientInterfaceFunctions.WaitForCompletionFunction wfcf = new HyracksClientInterfaceFunctions.WaitForCompletionFunction(jobId, statOperatorNames);
        return (List)this.rpci.call(this.ipcHandle, wfcf);
    }

    public Map<String, NodeControllerInfo> getNodeControllersInfo() throws Exception {
        HyracksClientInterfaceFunctions.GetNodeControllersInfoFunction gncif = new HyracksClientInterfaceFunctions.GetNodeControllersInfoFunction();
        return (Map)this.rpci.call(this.ipcHandle, gncif);
    }

    public ClusterTopology getClusterTopology() throws Exception {
        HyracksClientInterfaceFunctions.GetClusterTopologyFunction gctf = new HyracksClientInterfaceFunctions.GetClusterTopologyFunction();
        return (ClusterTopology)this.rpci.call(this.ipcHandle, gctf);
    }

    public void deployBinary(List<URL> binaryURLs, DeploymentId deploymentId) throws Exception {
        HyracksClientInterfaceFunctions.CliDeployBinaryFunction dbf = new HyracksClientInterfaceFunctions.CliDeployBinaryFunction(binaryURLs, deploymentId);
        this.rpci.call(this.ipcHandle, dbf);
    }

    public void unDeployBinary(DeploymentId deploymentId) throws Exception {
        HyracksClientInterfaceFunctions.CliUnDeployBinaryFunction dbf = new HyracksClientInterfaceFunctions.CliUnDeployBinaryFunction(deploymentId);
        this.rpci.call(this.ipcHandle, dbf);
    }

    public JobInfo getJobInfo(JobId jobId) throws Exception {
        HyracksClientInterfaceFunctions.GetJobInfoFunction gjsf = new HyracksClientInterfaceFunctions.GetJobInfoFunction(jobId);
        return (JobInfo)this.rpci.call(this.ipcHandle, gjsf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCluster(boolean terminateNCService) throws Exception {
        HyracksClientInterfaceFunctions.ClusterShutdownFunction csdf = new HyracksClientInterfaceFunctions.ClusterShutdownFunction(terminateNCService);
        this.rpci.call(this.ipcHandle, csdf);
        int i = 0;
        while (this.ipcHandle.isConnected() && i++ < 30) {
            HyracksClientInterfaceRemoteProxy hyracksClientInterfaceRemoteProxy = this;
            synchronized (hyracksClientInterfaceRemoteProxy) {
                this.wait(TimeUnit.SECONDS.toMillis(1L));
            }
        }
        if (this.ipcHandle.isConnected()) {
            throw new IPCException("CC refused to release connection after 30 seconds");
        }
    }

    public String getNodeDetailsJSON(String nodeId, boolean includeStats, boolean includeConfig) throws Exception {
        HyracksClientInterfaceFunctions.GetNodeDetailsJSONFunction gjsf = new HyracksClientInterfaceFunctions.GetNodeDetailsJSONFunction(nodeId, includeStats, includeConfig);
        return (String)this.rpci.call(this.ipcHandle, gjsf);
    }

    public String getThreadDump(String node) throws Exception {
        HyracksClientInterfaceFunctions.ThreadDumpFunction tdf = new HyracksClientInterfaceFunctions.ThreadDumpFunction(node);
        return (String)this.rpci.call(this.ipcHandle, tdf);
    }

    public boolean isConnected() {
        return this.ipcHandle.isConnected();
    }
}

