/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum SqlppHint {
    AUTO_HINT("auto"),
    HASH_BROADCAST_JOIN_HINT("hash-bcast"),
    COMPOSE_VAL_FILES_HINT("compose-val-files"),
    DATE_BETWEEN_YEARS_HINT("date-between-years"),
    DATETIME_ADD_RAND_HOURS_HINT("datetime-add-rand-hours"),
    DATETIME_BETWEEN_YEARS_HINT("datetime-between-years"),
    HASH_GROUP_BY_HINT("hash"),
    INDEXED_NESTED_LOOP_JOIN_HINT("indexnl"),
    INMEMORY_HINT("inmem"),
    INSERT_RAND_INT_HINT("insert-rand-int"),
    INTERVAL_HINT("interval"),
    LIST_HINT("list"),
    LIST_VAL_FILE_HINT("list-val-file"),
    RANGE_HINT("range"),
    SKIP_SECONDARY_INDEX_SEARCH_HINT("skip-index"),
    SPATIAL_JOIN_HINT("spatial-partitioning"),
    USE_SECONDARY_INDEX_SEARCH_HINT("use-index"),
    VAL_FILE_HINT("val-files"),
    VAL_FILE_SAME_INDEX_HINT("val-file-same-idx"),
    GEN_FIELDS_HINT("gen-fields"),
    DGEN_HINT("dgen");

    private static final Map<String, SqlppHint> ID_MAP;
    private final String id;

    private SqlppHint(String id) {
        this.id = Objects.requireNonNull(id);
    }

    public String getIdentifier() {
        return this.id;
    }

    public String toString() {
        return this.getIdentifier();
    }

    public static SqlppHint findByIdentifier(String id) {
        return ID_MAP.get(id);
    }

    private static Map<String, SqlppHint> createIdentifierMap(SqlppHint[] values) {
        HashMap<String, SqlppHint> map = new HashMap<String, SqlppHint>();
        for (SqlppHint hint : values) {
            map.put(hint.getIdentifier(), hint);
        }
        return map;
    }

    public static int findParamStart(String str) {
        int ln = str.length();
        for (int i = 0; i < ln; ++i) {
            if (SqlppHint.isIdentifierChar(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean isIdentifierChar(char c) {
        return Character.isJavaIdentifierStart(c) || c == '-';
    }

    static {
        ID_MAP = SqlppHint.createIdentifierMap(SqlppHint.values());
    }
}

