/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.work;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorkQueue {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean DEBUG = false;
    private final LinkedBlockingQueue<AbstractWork> queue;
    private final WorkerThread thread;
    private boolean stopped;
    private AtomicInteger enqueueCount;
    private AtomicInteger dequeueCount;
    private int threadPriority = 10;
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    public WorkQueue(String id, int threadPriority) {
        if (threadPriority != 10 && threadPriority != 5 && threadPriority != 1) {
            throw new IllegalArgumentException("Illegal thread priority number.");
        }
        this.threadPriority = threadPriority;
        this.queue = new LinkedBlockingQueue();
        this.thread = new WorkerThread(id);
        this.stopped = true;
    }

    public void start() throws HyracksException {
        this.stopped = false;
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws HyracksException {
        WorkQueue workQueue = this;
        synchronized (workQueue) {
            this.stopped = true;
        }
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw HyracksException.create((Throwable)e);
        }
    }

    public void schedule(AbstractWork event) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Scheduling: " + event);
        }
        this.queue.offer(event);
    }

    public void scheduleAndSync(SynchronizableWork sRunnable) throws Exception {
        this.schedule(sRunnable);
        sRunnable.sync();
    }

    private class WorkerThread
    extends Thread {
        WorkerThread(String id) {
            this.setName("Worker:" + id);
            this.setDaemon(true);
            this.setPriority(WorkQueue.this.threadPriority);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                AbstractWork r;
                WorkQueue workQueue = WorkQueue.this;
                synchronized (workQueue) {
                    if (WorkQueue.this.stopped) {
                        return;
                    }
                }
                try {
                    r = WorkQueue.this.queue.take();
                }
                catch (InterruptedException e) {
                    return;
                }
                if (LOGGER.isEnabled(r.logLevel())) {
                    LOGGER.log(r.logLevel(), "Executing: " + r);
                }
                ThreadInfo before = WorkQueue.this.threadMXBean.getThreadInfo(WorkQueue.this.thread.getId());
                try {
                    r.run();
                    continue;
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARN, "Exception while executing " + r, (Throwable)e);
                    continue;
                }
                finally {
                    if (!LOGGER.isTraceEnabled()) continue;
                    this.traceWaitsAndBlocks(r, before);
                    continue;
                }
                break;
            }
        }

        protected void traceWaitsAndBlocks(AbstractWork r, ThreadInfo before) {
            ThreadInfo after = WorkQueue.this.threadMXBean.getThreadInfo(WorkQueue.this.thread.getId());
            long waitedDelta = after.getWaitedCount() - before.getWaitedCount();
            long blockedDelta = after.getBlockedCount() - before.getBlockedCount();
            if (waitedDelta > 0L || blockedDelta > 0L) {
                LOGGER.trace("Work {} waited {} times (~{}ms), blocked {} times (~{}ms)", (Object)r, (Object)waitedDelta, (Object)(after.getWaitedTime() - before.getWaitedTime()), (Object)blockedDelta, (Object)(after.getBlockedTime() - before.getBlockedTime()));
            }
        }
    }
}

