/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.SemanticVersion;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;

final class JacksonVersion {
    private SemanticVersion annotationsVersion;
    private SemanticVersion coreVersion;
    private SemanticVersion databindVersion;
    private SemanticVersion xmlVersion;
    private SemanticVersion jsr310Version;
    private static final String ANNOTATIONS_PACKAGE_NAME = "jackson-annotations";
    private static final String CORE_PACKAGE_NAME = "jackson-core";
    private static final String DATABIND_PACKAGE_NAME = "jackson-databind";
    private static final String XML_PACKAGE_NAME = "jackson-dataformat-xml";
    private static final String JSR310_PACKAGE_NAME = "jackson-datatype-jsr310";
    private static final String TROUBLESHOOTING_DOCS_LINK = "https://aka.ms/azsdk/java/dependency/troubleshoot";
    private static final SemanticVersion MIN_SUPPORTED_VERSION = SemanticVersion.parse("2.10.0");
    private static final int MAX_SUPPORTED_MAJOR_VERSION = 2;
    private static final String AZURE_CORE_PROPERTIES_NAME = "azure-core.properties";
    private static final String AZURE_CORE_PROPERTIES_VERSION_KEY = "version";
    private static final String AZURE_CORE_VERSION = CoreUtils.getProperties("azure-core.properties").getOrDefault("version", "unknown");
    private static JacksonVersion instance = null;
    private final String helpString;
    private final ClientLogger logger = new ClientLogger(JacksonVersion.class);

    private JacksonVersion() {
        this.annotationsVersion = SemanticVersion.getPackageVersionForClass("com.fasterxml.jackson.annotation.JsonProperty");
        this.coreVersion = SemanticVersion.getPackageVersionForClass("com.fasterxml.jackson.core.JsonGenerator");
        this.databindVersion = SemanticVersion.getPackageVersionForClass("com.fasterxml.jackson.databind.ObjectMapper");
        this.xmlVersion = SemanticVersion.getPackageVersionForClass("com.fasterxml.jackson.dataformat.xml.XmlMapper");
        this.jsr310Version = SemanticVersion.getPackageVersionForClass("com.fasterxml.jackson.datatype.jsr310.JavaTimeModule");
        this.checkVersion(this.annotationsVersion, ANNOTATIONS_PACKAGE_NAME);
        this.checkVersion(this.coreVersion, CORE_PACKAGE_NAME);
        this.checkVersion(this.databindVersion, DATABIND_PACKAGE_NAME);
        this.checkVersion(this.xmlVersion, XML_PACKAGE_NAME);
        this.checkVersion(this.jsr310Version, JSR310_PACKAGE_NAME);
        this.helpString = this.formatHelpString();
        this.logger.info(this.helpString);
    }

    public String getHelpInfo() {
        return this.helpString;
    }

    public static synchronized JacksonVersion getInstance() {
        if (instance == null) {
            instance = new JacksonVersion();
        }
        return instance;
    }

    private void checkVersion(SemanticVersion version, String packageName) {
        if (!version.isValid()) {
            this.logger.verbose("Could not find version of '{}'.", packageName);
            return;
        }
        if (version.compareTo(MIN_SUPPORTED_VERSION) < 0) {
            this.logger.error("Version '{}' of package '{}' is not supported (older than earliest supported version - `{}`), please upgrade.", version.getVersionString(), packageName, MIN_SUPPORTED_VERSION);
        }
        if (version.getMajorVersion() > 2) {
            this.logger.error("Major version '{}' of package '{}' is newer than latest supported version - '{}'.", version.getVersionString(), packageName, 2);
        }
    }

    private String formatHelpString() {
        return "Package versions: " + ANNOTATIONS_PACKAGE_NAME + "=" + this.annotationsVersion.getVersionString() + ", " + CORE_PACKAGE_NAME + "=" + this.coreVersion.getVersionString() + ", " + DATABIND_PACKAGE_NAME + "=" + this.databindVersion.getVersionString() + ", " + XML_PACKAGE_NAME + "=" + this.xmlVersion.getVersionString() + ", " + JSR310_PACKAGE_NAME + "=" + this.jsr310Version.getVersionString() + ", " + "azure-core=" + AZURE_CORE_VERSION + ", " + "Troubleshooting version conflicts: " + TROUBLESHOOTING_DOCS_LINK;
    }
}

