/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.s3a.impl.AbstractStoreOperation;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.s3guard.DDBPathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.DynamoDBMetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.ExitCodeProvider;
import org.apache.hadoop.util.ExitUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthoritativeAuditOperation
extends AbstractStoreOperation {
    private static final Logger LOG = LoggerFactory.getLogger(AuthoritativeAuditOperation.class);
    public static final int ERROR_ENTRY_NOT_AUTH_IN_DDB = 46;
    public static final int ERROR_PATH_NOT_AUTH_IN_FS = 5;
    public static final String E_NONAUTH = "Directory is not marked as authoritative in the S3Guard store";
    private final DynamoDBMetadataStore metastore;
    private final boolean requireAuthoritative;
    private final boolean verbose;

    public AuthoritativeAuditOperation(StoreContext storeContext, DynamoDBMetadataStore metastore, boolean requireAuthoritative, boolean verbose) {
        super(storeContext);
        this.metastore = metastore;
        this.requireAuthoritative = requireAuthoritative;
        this.verbose = verbose;
    }

    private void verifyAuthDir(DDBPathMetadata md, boolean requireAuth) throws PathIOException {
        boolean isAuth;
        Path path = md.getFileStatus().getPath();
        boolean bl = isAuth = path.isRoot() || md.isAuthoritativeDir();
        if (!isAuth && requireAuth) {
            throw new NonAuthoritativeDirException(path);
        }
    }

    private boolean isDirectory(PathMetadata md) {
        return !md.getFileStatus().isFile();
    }

    public Pair<Integer, Integer> audit(Path path) throws IOException {
        try (DurationInfo ignored = new DurationInfo(LOG, "Audit %s", new Object[]{path});){
            Pair<Integer, Integer> pair = this.executeAudit(path, this.requireAuthoritative, true);
            return pair;
        }
    }

    @VisibleForTesting
    Pair<Integer, Integer> executeAudit(Path path, boolean requireAuth, boolean recursive) throws IOException {
        int dirs = 0;
        int nonauth = 0;
        ArrayDeque<DDBPathMetadata> queue = new ArrayDeque<DDBPathMetadata>();
        boolean isRoot = path.isRoot();
        DDBPathMetadata baseData = this.metastore.get(path);
        if (baseData == null) {
            throw new ExitUtil.ExitException(44, "No S3Guard entry for path " + path);
        }
        if (isRoot || this.isDirectory(baseData)) {
            queue.add(baseData);
        } else {
            LOG.info("Path represents file");
            return Pair.of((Object)0, (Object)0);
        }
        while (!queue.isEmpty()) {
            ++dirs;
            DDBPathMetadata dir = (DDBPathMetadata)queue.poll();
            Path p = dir.getFileStatus().getPath();
            LOG.debug("Directory {}", (Object)dir.prettyPrint());
            if (!p.isRoot()) {
                if (!dir.isAuthoritativeDir()) {
                    LOG.warn("Directory {} is not authoritative", (Object)p);
                    ++nonauth;
                    this.verifyAuthDir(dir, requireAuth);
                } else {
                    LOG.info("Directory {}", (Object)p);
                }
            } else {
                LOG.info("Root directory {}", (Object)p);
            }
            if (!recursive) continue;
            DirListingMetadata entry = this.metastore.listChildren(p);
            if (entry != null) {
                Collection<PathMetadata> listing = entry.getListing();
                int files = 0;
                int subdirs = 0;
                for (PathMetadata e : listing) {
                    if (this.isDirectory(e)) {
                        queue.add((DDBPathMetadata)e);
                        ++subdirs;
                        continue;
                    }
                    ++files;
                }
                if ((!this.verbose || files <= 0) && subdirs <= 0) continue;
                LOG.info("  files {}; directories {}", (Object)files, (Object)subdirs);
                continue;
            }
            LOG.info("Directory {} has been deleted", (Object)dir);
        }
        if (dirs == 1 && isRoot) {
            LOG.info("The store has no directories to scan");
        } else {
            LOG.info("Scanned {} directories - {} were not marked as authoritative", (Object)dirs, (Object)nonauth);
        }
        return Pair.of((Object)dirs, (Object)nonauth);
    }

    public static final class NonAuthoritativeDirException
    extends PathIOException
    implements ExitCodeProvider {
        private NonAuthoritativeDirException(Path path) {
            super(path.toString(), AuthoritativeAuditOperation.E_NONAUTH);
        }

        public int getExitCode() {
            return 46;
        }

        public String toString() {
            return this.getMessage();
        }
    }
}

