/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.typing;

import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMissableTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.properties.TypePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.AbstractTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypeEnvPointer;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;

public class PropagatingTypeEnvironment
extends AbstractTypeEnvironment {
    private final TypePropagationPolicy policy;
    private final IMissableTypeComputer missableTypeComputer;
    private final ITypeEnvPointer[] envPointers;
    private final List<LogicalVariable> nonMissableVariables = new ArrayList<LogicalVariable>();
    private final List<List<LogicalVariable>> correlatedMissableVariableLists = new ArrayList<List<LogicalVariable>>();
    private final List<LogicalVariable> nonNullableVariables = new ArrayList<LogicalVariable>();
    private final List<List<LogicalVariable>> correlatedNullableVariableLists = new ArrayList<List<LogicalVariable>>();

    public PropagatingTypeEnvironment(IExpressionTypeComputer expressionTypeComputer, IMissableTypeComputer missableTypeComputer, IMetadataProvider<?, ?> metadataProvider, TypePropagationPolicy policy, ITypeEnvPointer[] envPointers) {
        super(expressionTypeComputer, metadataProvider);
        this.missableTypeComputer = missableTypeComputer;
        this.policy = policy;
        this.envPointers = envPointers;
    }

    @Override
    public Object getVarType(LogicalVariable var) throws AlgebricksException {
        return this.getVarTypeFullList(var, null, null, null, null);
    }

    public List<LogicalVariable> getNonMissableVariables() {
        return this.nonMissableVariables;
    }

    public List<List<LogicalVariable>> getCorrelatedMissableVariableLists() {
        return this.correlatedMissableVariableLists;
    }

    public List<LogicalVariable> getNonNullableVariables() {
        return this.nonNullableVariables;
    }

    public List<List<LogicalVariable>> getCorrelatedNullableVariableLists() {
        return this.correlatedNullableVariableLists;
    }

    @Override
    public Object getVarType(LogicalVariable var, List<LogicalVariable> nonMissableVariables, List<List<LogicalVariable>> correlatedMissableVariableLists, List<LogicalVariable> nonNullableVariables, List<List<LogicalVariable>> correlatedNullableVariableLists) throws AlgebricksException {
        return this.getVarTypeFullList(var, nonMissableVariables, correlatedMissableVariableLists, nonNullableVariables, correlatedNullableVariableLists);
    }

    private Object getVarTypeFullList(LogicalVariable var, List<LogicalVariable> nonMissableVariableListExtra, List<List<LogicalVariable>> correlatedMissableVariableListsExtra, List<LogicalVariable> nonNullableVariableListExtra, List<List<LogicalVariable>> correlatedNullableVariableListsExtra) throws AlgebricksException {
        Object t = this.varTypeMap.get(var);
        if (t != null) {
            return t;
        }
        List<LogicalVariable> nonMissable = OperatorPropertiesUtil.unionAll(this.nonMissableVariables, nonMissableVariableListExtra);
        List<LogicalVariable> nonNullable = OperatorPropertiesUtil.unionAll(this.nonNullableVariables, nonNullableVariableListExtra);
        List<List<LogicalVariable>> correlatedMissable = OperatorPropertiesUtil.unionAll(this.correlatedMissableVariableLists, correlatedMissableVariableListsExtra);
        List<List<LogicalVariable>> correlatedNullable = OperatorPropertiesUtil.unionAll(this.correlatedNullableVariableLists, correlatedNullableVariableListsExtra);
        return this.policy.getVarType(var, this.missableTypeComputer, nonMissable, correlatedMissable, nonNullable, correlatedNullable, this.envPointers);
    }

    @Override
    public boolean substituteProducedVariable(LogicalVariable v1, LogicalVariable v2) throws AlgebricksException {
        boolean result = super.substituteProducedVariable(v1, v2);
        if (this.nonMissableVariables.remove(v1)) {
            this.nonMissableVariables.add(v2);
        }
        for (List<LogicalVariable> missableVarList : this.correlatedMissableVariableLists) {
            if (!missableVarList.remove(v1)) continue;
            missableVarList.add(v2);
        }
        if (this.nonNullableVariables.remove(v1)) {
            this.nonNullableVariables.add(v2);
        }
        for (List<LogicalVariable> nullableVarList : this.correlatedNullableVariableLists) {
            if (!nullableVarList.remove(v1)) continue;
            nullableVarList.add(v2);
        }
        return result;
    }
}

