/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;

public class DatasetConfig {

    public static enum DatasetFormat {
        ROW("row"),
        COLUMN("column");

        private final String format;
        private static final Map<String, DatasetFormat> FORMATS;

        private DatasetFormat(String format) {
            this.format = format;
        }

        private static Map<String, DatasetFormat> createFormats() {
            HashMap<String, DatasetFormat> formats = new HashMap<String, DatasetFormat>();
            for (DatasetFormat format : DatasetFormat.values()) {
                formats.put(format.format, format);
            }
            return formats;
        }

        public static DatasetFormat getFormat(String format) throws CompilationException {
            DatasetFormat formatEnum = FORMATS.get(format.trim().toLowerCase());
            if (formatEnum == null) {
                throw CompilationException.create(ErrorCode.UNKNOWN_STORAGE_FORMAT, new Serializable[]{format});
            }
            return formatEnum;
        }

        static {
            FORMATS = DatasetFormat.createFormats();
        }
    }

    public static enum ExternalFilePendingOp {
        NO_OP,
        ADD_OP,
        DROP_OP,
        APPEND_OP;

    }

    public static enum TransactionState {
        COMMIT,
        BEGIN,
        READY_TO_COMMIT;

    }

    public static enum IndexType {
        BTREE,
        RTREE,
        SINGLE_PARTITION_WORD_INVIX,
        SINGLE_PARTITION_NGRAM_INVIX,
        LENGTH_PARTITIONED_WORD_INVIX,
        LENGTH_PARTITIONED_NGRAM_INVIX,
        ARRAY,
        SAMPLE;

    }

    public static enum DatasetType {
        INTERNAL,
        EXTERNAL,
        VIEW;

    }
}

