/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum PartitioningScheme {
    DYNAMIC("dynamic"),
    STATIC("static");

    private static final Map<String, PartitioningScheme> partitioningSchemes;
    private final String str;

    private PartitioningScheme(String str) {
        this.str = str;
    }

    public String getStr() {
        return this.str;
    }

    public static PartitioningScheme fromName(String name) {
        PartitioningScheme partitioningScheme = partitioningSchemes.get(name.toLowerCase());
        if (partitioningScheme == null) {
            throw new IllegalArgumentException("unknonw partitioning scheme: " + name);
        }
        return partitioningScheme;
    }

    static {
        partitioningSchemes = Collections.unmodifiableMap(Arrays.stream(PartitioningScheme.values()).collect(Collectors.toMap(PartitioningScheme::getStr, Function.identity())));
    }
}

