/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.common.api.IExtendedModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentFilterHelper;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMPageWriteCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.freepage.VirtualFreePageManager;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMemoryComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeOpContext;
import org.apache.hyracks.storage.am.rtree.frames.RTreeFrameFactory;
import org.apache.hyracks.storage.am.rtree.impls.RTree;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.util.trace.ITracer;

public abstract class AbstractLSMRTree
extends AbstractLSMIndex
implements ITreeIndex {
    protected final ILinearizeComparatorFactory linearizer;
    protected final int[] comparatorFields;
    protected final IBinaryComparatorFactory[] linearizerArray;
    protected final boolean isPointMBR;
    protected IBinaryComparatorFactory[] btreeCmpFactories;
    protected IBinaryComparatorFactory[] rtreeCmpFactories;
    protected final ITreeIndexFrameFactory rtreeInteriorFrameFactory;
    protected final ITreeIndexFrameFactory btreeInteriorFrameFactory;
    protected final ITreeIndexFrameFactory rtreeLeafFrameFactory;
    protected final ITreeIndexFrameFactory btreeLeafFrameFactory;

    public AbstractLSMRTree(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, RTreeFrameFactory rtreeInteriorFrameFactory, RTreeFrameFactory rtreeLeafFrameFactory, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, IBufferCache diskBufferCache, ILSMIndexFileManager fileManager, ILSMDiskComponentFactory componentFactory, ILSMDiskComponentFactory bulkLoadComponentFactory, int fieldCount, IBinaryComparatorFactory[] rtreeCmpFactories, IBinaryComparatorFactory[] btreeCmpFactories, ILinearizeComparatorFactory linearizer, int[] comparatorFields, IBinaryComparatorFactory[] linearizerArray, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallbackFactory ioOpCallbackFactory, ILSMPageWriteCallbackFactory pageWriteCallbackFactory, IComponentFilterHelper filterHelper, ILSMComponentFilterFrameFactory filterFrameFactory, LSMComponentFilterManager filterManager, int[] rtreeFields, int[] filterFields, boolean durable, boolean isPointMBR) throws HyracksDataException {
        super(ioManager, virtualBufferCaches, diskBufferCache, fileManager, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallbackFactory, pageWriteCallbackFactory, componentFactory, bulkLoadComponentFactory, filterFrameFactory, filterManager, filterFields, durable, filterHelper, rtreeFields, ITracer.NONE);
        int i = 0;
        for (IVirtualBufferCache virtualBufferCache : virtualBufferCaches) {
            RTree memRTree = new RTree((IBufferCache)virtualBufferCache, (IPageManager)new VirtualFreePageManager((IBufferCache)virtualBufferCache), (ITreeIndexFrameFactory)rtreeInteriorFrameFactory, (ITreeIndexFrameFactory)rtreeLeafFrameFactory, rtreeCmpFactories, fieldCount, ioManager.resolveAbsolutePath(fileManager.getBaseDir() + "_virtual_r_" + i), isPointMBR);
            BTree memBTree = new BTree((IBufferCache)virtualBufferCache, (IPageManager)new VirtualFreePageManager((IBufferCache)virtualBufferCache), btreeInteriorFrameFactory, btreeLeafFrameFactory, btreeCmpFactories, btreeCmpFactories.length, ioManager.resolveAbsolutePath(fileManager.getBaseDir() + "_virtual_b_" + i));
            LSMRTreeMemoryComponent mutableComponent = new LSMRTreeMemoryComponent(this, memRTree, memBTree, virtualBufferCache, filterHelper == null ? null : filterHelper.createFilter());
            this.memoryComponents.add(mutableComponent);
            ++i;
        }
        this.rtreeInteriorFrameFactory = rtreeInteriorFrameFactory;
        this.rtreeLeafFrameFactory = rtreeLeafFrameFactory;
        this.btreeInteriorFrameFactory = btreeInteriorFrameFactory;
        this.btreeLeafFrameFactory = btreeLeafFrameFactory;
        this.btreeCmpFactories = btreeCmpFactories;
        this.rtreeCmpFactories = rtreeCmpFactories;
        this.linearizer = linearizer;
        this.comparatorFields = comparatorFields;
        this.linearizerArray = linearizerArray;
        this.isPointMBR = isPointMBR;
    }

    public void search(ILSMIndexOperationContext ictx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException {
        LSMRTreeOpContext ctx = (LSMRTreeOpContext)ictx;
        cursor.open((ICursorInitialState)ctx.getSearchInitialState(), pred);
    }

    public ITreeIndexFrameFactory getLeafFrameFactory() {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getIndex().getLeafFrameFactory();
    }

    public ITreeIndexFrameFactory getInteriorFrameFactory() {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getIndex().getInteriorFrameFactory();
    }

    public IPageManager getPageManager() {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getIndex().getPageManager();
    }

    public int getFieldCount() {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getIndex().getFieldCount();
    }

    public int getRootPageId() {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getIndex().getRootPageId();
    }

    public int getFileId() {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getIndex().getFileId();
    }

    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException {
        LSMRTreeOpContext ctx;
        block7: {
            ITupleReference indexTuple;
            ctx = (LSMRTreeOpContext)ictx;
            if (ctx.getOperation() == IndexOperation.PHYSICALDELETE) {
                throw new UnsupportedOperationException("Physical delete not supported in the LSM-RTree");
            }
            if (ctx.getIndexTuple() != null) {
                ctx.getIndexTuple().reset(tuple);
                indexTuple = ctx.getIndexTuple();
            } else {
                indexTuple = tuple;
            }
            ctx.getModificationCallback().before(indexTuple);
            ctx.getModificationCallback().found(null, indexTuple);
            if (ctx.getOperation() == IndexOperation.INSERT) {
                ctx.getCurrentMutableRTreeAccessor().insert(indexTuple);
            } else {
                ctx.getCurrentMutableRTreeAccessor().delete(indexTuple);
                try {
                    ctx.getCurrentMutableBTreeAccessor().insert(indexTuple);
                }
                catch (HyracksDataException e) {
                    if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) break block7;
                    throw e;
                }
            }
        }
        this.updateFilter((ILSMIndexOperationContext)ctx, tuple);
    }

    protected LSMRTreeOpContext createOpContext(IIndexAccessParameters iap) {
        return new LSMRTreeOpContext((ILSMIndex)this, this.memoryComponents, this.rtreeLeafFrameFactory, this.rtreeInteriorFrameFactory, this.btreeLeafFrameFactory, (IExtendedModificationOperationCallback)iap.getModificationCallback(), iap.getSearchOperationCallback(), this.getTreeFields(), this.getFilterFields(), this.getHarness(), this.comparatorFields, this.linearizerArray, this.getFilterCmpFactories(), this.tracer);
    }

    public IBinaryComparatorFactory[] getComparatorFactories() {
        return this.rtreeCmpFactories;
    }

    public boolean isPrimaryIndex() {
        return false;
    }

    protected LSMComponentFileReferences getMergeFileReferences(ILSMDiskComponent firstComponent, ILSMDiskComponent lastComponent) throws HyracksDataException {
        RTree firstTree = (RTree)firstComponent.getIndex();
        RTree lastTree = (RTree)lastComponent.getIndex();
        FileReference firstFile = firstTree.getFileReference();
        FileReference lastFile = lastTree.getFileReference();
        return this.fileManager.getRelMergeFileReference(firstFile.getFile().getName(), lastFile.getFile().getName());
    }
}

