/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.builders;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.dataflow.data.nontagged.serde.SerializerDeserializerUtil;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.runtime.RuntimeRecordTypeInfo;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.accessors.PointableBinaryHashFunctionFactory;
import org.apache.hyracks.data.std.accessors.UTF8StringBinaryComparatorFactory;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleOutputStream;
import org.apache.hyracks.dataflow.common.data.marshalling.UTF8StringSerializerDeserializer;

public class RecordBuilder
implements IARecordBuilder {
    private static final int DEFAULT_NUM_OPEN_FIELDS = 10;
    private final UTF8StringSerializerDeserializer utf8SerDer = new UTF8StringSerializerDeserializer();
    private int openPartOffsetArraySize = 0;
    private byte[] openPartOffsetArray = null;
    private int offsetPosition = 0;
    private int headerSize;
    private boolean isOpen;
    private boolean containsOptionalField;
    private int numberOfSchemaFields;
    private int openPartOffset;
    private ARecordType recType;
    private final IBinaryHashFunction utf8HashFunction;
    private final IBinaryComparator utf8Comparator;
    private final ByteArrayAccessibleOutputStream closedPartOutputStream = new ByteArrayAccessibleOutputStream();
    private int[] closedPartOffsets;
    private int numberOfClosedFields = 0;
    private byte[] nullBitMap;
    private int nullBitMapSize;
    private final ByteArrayAccessibleOutputStream openPartOutputStream = new ByteArrayAccessibleOutputStream();
    private long[] openPartOffsets = new long[10];
    private int[] openFieldNameLengths = new int[10];
    private int numberOfOpenFields = 0;
    private final RuntimeRecordTypeInfo recTypeInfo;
    private final IntOpenHashSet fieldNamesHashes;

    public RecordBuilder() {
        this.utf8HashFunction = new PointableBinaryHashFunctionFactory((IPointableFactory)UTF8StringPointable.FACTORY).createBinaryHashFunction();
        this.utf8Comparator = UTF8StringBinaryComparatorFactory.INSTANCE.createBinaryComparator();
        this.recTypeInfo = new RuntimeRecordTypeInfo();
        this.fieldNamesHashes = new IntOpenHashSet();
    }

    @Override
    public void init() {
        this.numberOfClosedFields = 0;
        this.closedPartOutputStream.reset();
        this.openPartOutputStream.reset();
        this.numberOfOpenFields = 0;
        this.offsetPosition = 0;
        this.fieldNamesHashes.clear();
        if (this.nullBitMap != null) {
            Arrays.fill(this.nullBitMap, (byte)-86);
        }
    }

    @Override
    public void reset(ARecordType recType) {
        this.recType = recType;
        this.recTypeInfo.reset(recType);
        this.closedPartOutputStream.reset();
        this.openPartOutputStream.reset();
        this.numberOfClosedFields = 0;
        this.numberOfOpenFields = 0;
        this.offsetPosition = 0;
        this.fieldNamesHashes.clear();
        if (recType != null) {
            this.isOpen = recType.isOpen();
            this.containsOptionalField = NonTaggedFormatUtil.hasOptionalField(recType);
            this.numberOfSchemaFields = recType.getFieldNames().length;
        } else {
            this.isOpen = true;
            this.containsOptionalField = false;
            this.numberOfSchemaFields = 0;
        }
        this.headerSize = 5;
        if (this.isOpen) {
            ++this.headerSize;
        }
        if (this.numberOfSchemaFields > 0) {
            this.headerSize += 4;
            if (this.closedPartOffsets == null || this.closedPartOffsets.length < this.numberOfSchemaFields) {
                this.closedPartOffsets = new int[this.numberOfSchemaFields];
            }
            if (this.containsOptionalField) {
                this.nullBitMapSize = (int)Math.ceil((double)this.numberOfSchemaFields / 4.0);
                if (this.nullBitMap == null || this.nullBitMap.length < this.nullBitMapSize) {
                    this.nullBitMap = new byte[this.nullBitMapSize];
                }
                Arrays.fill(this.nullBitMap, 0, this.nullBitMapSize, (byte)-86);
                this.headerSize += this.nullBitMapSize;
            }
        }
    }

    @Override
    public void addField(int fid, IValueReference value) {
        this.closedPartOffsets[fid] = this.closedPartOutputStream.size();
        int len = value.getLength() - 1;
        this.closedPartOutputStream.write(value.getByteArray(), value.getStartOffset() + 1, len);
        ++this.numberOfClosedFields;
        this.addNullOrMissingField(fid, value.getByteArray(), value.getStartOffset());
    }

    private void addNullOrMissingField(int fid, byte[] data, int offset) {
        if (this.containsOptionalField) {
            byte nullByte = (byte)(1 << 7 - 2 * (fid % 4));
            if (data[offset] == ATypeTag.SERIALIZED_NULL_TYPE_TAG) {
                int n = fid / 4;
                this.nullBitMap[n] = (byte)(this.nullBitMap[n] & ~nullByte);
            }
            if (data[offset] != ATypeTag.SERIALIZED_MISSING_TYPE_TAG) {
                int n = fid / 4;
                this.nullBitMap[n] = (byte)(this.nullBitMap[n] | (byte)(1 << 7 - 2 * (fid % 4) - 1));
            }
        }
    }

    @Override
    public void addField(IValueReference name, IValueReference value) throws HyracksDataException {
        int nameOffset;
        int offset;
        byte[] data = value.getByteArray();
        if (data[offset = value.getStartOffset()] == ATypeTag.SERIALIZED_MISSING_TYPE_TAG) {
            return;
        }
        byte[] nameBytes = name.getByteArray();
        if (nameBytes[nameOffset = name.getStartOffset()] == ATypeTag.SERIALIZED_MISSING_TYPE_TAG || nameBytes[nameOffset] == ATypeTag.SERIALIZED_NULL_TYPE_TAG) {
            return;
        }
        int nameStart = nameOffset + 1;
        int nameLength = name.getLength() - 1;
        if (this.recType != null && this.recTypeInfo.getFieldIndex(nameBytes, nameStart, nameLength) >= 0) {
            return;
        }
        int fieldNameHashCode = this.utf8HashFunction.hash(nameBytes, nameStart, nameLength);
        if (!this.fieldNamesHashes.add(fieldNameHashCode)) {
            for (int i = 0; i < this.numberOfOpenFields; ++i) {
                if (!this.isDuplicate(nameBytes, nameStart, nameLength, fieldNameHashCode, i)) continue;
                return;
            }
        }
        if (this.numberOfOpenFields == this.openPartOffsets.length) {
            this.openPartOffsets = Arrays.copyOf(this.openPartOffsets, this.openPartOffsets.length + 10);
            this.openFieldNameLengths = Arrays.copyOf(this.openFieldNameLengths, this.openFieldNameLengths.length + 10);
        }
        this.openPartOffsets[this.numberOfOpenFields] = fieldNameHashCode;
        this.openPartOffsets[this.numberOfOpenFields] = this.openPartOffsets[this.numberOfOpenFields] << 32;
        int n = this.numberOfOpenFields;
        this.openPartOffsets[n] = this.openPartOffsets[n] + (long)this.openPartOutputStream.size();
        this.openFieldNameLengths[this.numberOfOpenFields++] = nameLength;
        this.openPartOutputStream.write(nameBytes, nameStart, nameLength);
        this.openPartOutputStream.write(data, offset, value.getLength());
    }

    @Override
    public void write(DataOutput out, boolean writeTypeTag) throws HyracksDataException {
        int recordLength;
        int h = this.headerSize;
        if (this.numberOfOpenFields > 0) {
            h += 4;
            this.openPartOffsetArraySize = this.numberOfOpenFields * 8;
            if (this.openPartOffsetArray == null || this.openPartOffsetArray.length < this.openPartOffsetArraySize) {
                this.openPartOffsetArray = new byte[this.openPartOffsetArraySize];
            }
            Arrays.sort(this.openPartOffsets, 0, this.numberOfOpenFields);
            this.openPartOffset = h + this.numberOfSchemaFields * 4 + this.closedPartOutputStream.size();
            for (int i = 0; i < this.numberOfOpenFields; ++i) {
                int fieldNameHashCode = (int)(this.openPartOffsets[i] >> 32);
                SerializerDeserializerUtil.writeIntToByteArray(this.openPartOffsetArray, fieldNameHashCode, this.offsetPosition);
                int fieldOffset = (int)this.openPartOffsets[i];
                SerializerDeserializerUtil.writeIntToByteArray(this.openPartOffsetArray, fieldOffset + this.openPartOffset + 4 + this.openPartOffsetArraySize, this.offsetPosition + 4);
                this.offsetPosition += 8;
            }
            recordLength = this.openPartOffset + 4 + this.openPartOffsetArraySize + this.openPartOutputStream.size();
        } else {
            recordLength = h + this.numberOfSchemaFields * 4 + this.closedPartOutputStream.size();
        }
        this.writeRecord(out, writeTypeTag, h, recordLength);
    }

    private void writeRecord(DataOutput out, boolean writeTypeTag, int headerSize, int recordLength) throws HyracksDataException {
        try {
            if (writeTypeTag) {
                out.writeByte(ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
            }
            out.writeInt(recordLength);
            if (this.isOpen) {
                if (this.numberOfOpenFields > 0) {
                    out.writeBoolean(true);
                    out.writeInt(this.openPartOffset);
                } else {
                    out.writeBoolean(false);
                }
            }
            if (this.numberOfSchemaFields > 0) {
                out.writeInt(this.numberOfClosedFields);
                if (this.containsOptionalField) {
                    out.write(this.nullBitMap, 0, this.nullBitMapSize);
                }
                for (int i = 0; i < this.numberOfSchemaFields; ++i) {
                    out.writeInt(this.closedPartOffsets[i] + headerSize + this.numberOfSchemaFields * 4);
                }
                out.write(this.closedPartOutputStream.getByteArray(), 0, this.closedPartOutputStream.getLength());
            }
            if (this.numberOfOpenFields > 0) {
                out.writeInt(this.numberOfOpenFields);
                out.write(this.openPartOffsetArray, 0, this.openPartOffsetArraySize);
                out.write(this.openPartOutputStream.getByteArray(), 0, this.openPartOutputStream.getLength());
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public int getFieldId(String fieldName) {
        return this.recType.getFieldIndex(fieldName);
    }

    public IBinaryHashFunction getFieldNameHashFunction() {
        return this.utf8HashFunction;
    }

    public IBinaryComparator getFieldNameComparator() {
        return this.utf8Comparator;
    }

    private boolean isDuplicate(byte[] fName, int fStart, int fLen, int fNameHash, int otherFieldIdx) throws HyracksDataException {
        return (int)(this.openPartOffsets[otherFieldIdx] >>> 32) == fNameHash && this.utf8Comparator.compare(this.openPartOutputStream.getByteArray(), (int)this.openPartOffsets[otherFieldIdx], this.openFieldNameLengths[otherFieldIdx], fName, fStart, fLen) == 0;
    }
}

