/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hyracks.http.api.IServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServletRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SortedMap<String, IServlet> servletMap = new TreeMap(Comparator.reverseOrder());
    private final Set<IServlet> servlets = new HashSet<IServlet>();

    public void register(IServlet let) {
        this.servlets.add(let);
        for (String path : let.getPaths()) {
            LOGGER.debug("registering servlet {}[{}] with path {}", (Object)let, (Object)let.getClass().getName(), (Object)path);
            IServlet prev = this.servletMap.put(path, let);
            if (prev == null) continue;
            throw new IllegalStateException("duplicate servlet mapping! (path = " + path + ", orig = " + prev + "[" + prev.getClass().getName() + "], dup = " + let + "[" + let.getClass().getName() + "])");
        }
    }

    public Set<IServlet> getServlets() {
        return Collections.unmodifiableSet(this.servlets);
    }

    public IServlet getServlet(String uri) {
        String baseUri = HttpUtil.trimQuery(uri);
        return this.servletMap.entrySet().stream().filter(entry -> ServletRegistry.match((String)entry.getKey(), baseUri)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    static boolean match(String pathSpec, String path) {
        char c = pathSpec.charAt(0);
        if (c == '/') {
            if (pathSpec.equals(path) || pathSpec.length() == 1 && path.isEmpty()) {
                return true;
            }
            return ServletRegistry.isPathWildcardMatch(pathSpec, path);
        }
        if (c == '*') {
            return path.regionMatches(path.length() - pathSpec.length() + 1, pathSpec, 1, pathSpec.length() - 1);
        }
        return false;
    }

    static boolean isPathWildcardMatch(String pathSpec, String path) {
        int length = pathSpec.length();
        if (length < 2) {
            return false;
        }
        int cpl = length - 2;
        boolean b = pathSpec.endsWith("/*") && path.regionMatches(0, pathSpec, 0, cpl);
        return b && (path.length() == cpl || '/' == path.charAt(cpl));
    }
}

