/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.stream.in;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.DoublePointable;
import org.apache.hyracks.data.std.primitive.FloatPointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.LongPointable;

public final class ValueInputStream
extends InputStream {
    private final byte[] readBuffer = new byte[8];
    private InputStream in;

    public void reset(AbstractBytesInputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    public int readInt() throws IOException {
        this.readFully(this.readBuffer, 4);
        return IntegerPointable.getInteger((byte[])this.readBuffer, (int)0);
    }

    public long readLong() throws IOException {
        this.readFully(this.readBuffer, 8);
        return LongPointable.getLong((byte[])this.readBuffer, (int)0);
    }

    public float readFloat() throws IOException {
        this.readFully(this.readBuffer, 4);
        return FloatPointable.getFloat((byte[])this.readBuffer, (int)0);
    }

    public double readDouble() throws IOException {
        this.readFully(this.readBuffer, 8);
        return DoublePointable.getDouble((byte[])this.readBuffer, (int)0);
    }

    public IValueReference readBytes(IPointable valueStorage, int length) throws IOException {
        this.readFully(valueStorage.getByteArray(), length);
        return valueStorage;
    }

    public void skipBytes(int n) throws IOException {
        int cur;
        for (int total = 0; total < n && (cur = (int)this.in.skip(n - total)) > 0; total += cur) {
        }
    }

    private void readFully(byte[] bytes, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.in.read(bytes, n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }
}

