/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.stream.out;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hyracks.data.std.primitive.DoublePointable;
import org.apache.hyracks.data.std.primitive.FloatPointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.LongPointable;

public final class ValueOutputStream
extends OutputStream {
    private final OutputStream out;
    private final byte[] writeBuffer;

    public ValueOutputStream(OutputStream out) {
        this.out = out;
        this.writeBuffer = new byte[8];
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void writeInt(int value) throws IOException {
        IntegerPointable.setInteger((byte[])this.writeBuffer, (int)0, (int)value);
        this.out.write(this.writeBuffer, 0, 4);
    }

    public void writeLong(long value) throws IOException {
        LongPointable.setLong((byte[])this.writeBuffer, (int)0, (long)value);
        this.out.write(this.writeBuffer, 0, 8);
    }

    public void writeFloat(float value) throws IOException {
        FloatPointable.setFloat((byte[])this.writeBuffer, (int)0, (float)value);
        this.out.write(this.writeBuffer, 0, 4);
    }

    public void writeDouble(double value) throws IOException {
        DoublePointable.setDouble((byte[])this.writeBuffer, (int)0, (double)value);
        this.out.write(this.writeBuffer, 0, 8);
    }
}

