/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.operation.lsm.merge;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.asterix.column.operation.lsm.merge.MergeColumnWriteMetadata;
import org.apache.asterix.column.tuple.MergeColumnTupleReference;
import org.apache.asterix.column.util.RunLengthIntArray;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.asterix.column.values.IColumnValuesWriter;
import org.apache.asterix.column.values.writer.ColumnBatchWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.btree.column.api.AbstractColumnTupleWriter;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnTupleIterator;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;
import org.apache.hyracks.storage.am.lsm.btree.column.error.ColumnarValueException;

public class MergeColumnTupleWriter
extends AbstractColumnTupleWriter {
    private final MergeColumnWriteMetadata columnMetadata;
    private final int maxLeafNodeSize;
    private final MergeColumnTupleReference[] componentsTuples;
    private final RunLengthIntArray writtenComponents;
    private final IColumnValuesWriter[] primaryKeyWriters;
    private final PriorityQueue<IColumnValuesWriter> orderedColumns;
    private final ColumnBatchWriter writer;
    private final int maxNumberOfTuples;
    private int primaryKeysEstimatedSize;
    private int numberOfAntiMatter;

    public MergeColumnTupleWriter(MergeColumnWriteMetadata columnMetadata, int pageSize, int maxNumberOfTuples, double tolerance, int maxLeafNodeSize) {
        int i;
        this.columnMetadata = columnMetadata;
        this.maxLeafNodeSize = maxLeafNodeSize;
        List<IColumnTupleIterator> componentsTuplesList = columnMetadata.getComponentsTuples();
        this.componentsTuples = new MergeColumnTupleReference[componentsTuplesList.size()];
        int totalLength = 0;
        int totalNumberOfTuples = 0;
        for (i = 0; i < componentsTuplesList.size(); ++i) {
            MergeColumnTupleReference mergeTuple;
            this.componentsTuples[i] = mergeTuple = (MergeColumnTupleReference)componentsTuplesList.get(i);
            mergeTuple.registerEndOfPageCallBack(this::writeAllColumns);
            totalNumberOfTuples += mergeTuple.getTupleCount();
            totalLength += mergeTuple.getMergingLength();
        }
        this.maxNumberOfTuples = this.getMaxNumberOfTuples(maxNumberOfTuples, totalNumberOfTuples, totalLength);
        this.writtenComponents = new RunLengthIntArray();
        this.writer = new ColumnBatchWriter(columnMetadata.getMultiPageOpRef(), pageSize, tolerance);
        this.writtenComponents.reset();
        this.primaryKeyWriters = new IColumnValuesWriter[columnMetadata.getNumberOfPrimaryKeys()];
        for (i = 0; i < this.primaryKeyWriters.length; ++i) {
            this.primaryKeyWriters[i] = columnMetadata.getWriter(i);
        }
        this.orderedColumns = new PriorityQueue<IColumnValuesWriter>(Comparator.comparingInt(x -> -x.getEstimatedSize()));
        this.numberOfAntiMatter = 0;
    }

    public int bytesRequired(ITupleReference tuple) {
        int primaryKeysSize = 0;
        for (int i = 0; i < this.columnMetadata.getNumberOfPrimaryKeys(); ++i) {
            primaryKeysSize += this.primaryKeyWriters[i].getEstimatedSize(tuple.getFieldLength(i));
        }
        return primaryKeysSize;
    }

    public void init(IColumnWriteMultiPageOp multiPageOp) throws HyracksDataException {
        this.columnMetadata.init(multiPageOp);
    }

    public int getNumberOfColumns() {
        return this.columnMetadata.getNumberOfColumns();
    }

    public int getMaxNumberOfTuples() {
        return this.maxNumberOfTuples;
    }

    public int getOccupiedSpace() {
        int numberOfColumns = this.getNumberOfColumns();
        int filterSize = numberOfColumns * 16;
        return this.primaryKeysEstimatedSize + filterSize;
    }

    public void writeTuple(ITupleReference tuple) throws HyracksDataException {
        MergeColumnTupleReference columnTuple = (MergeColumnTupleReference)tuple;
        int componentIndex = columnTuple.getComponentIndex();
        int skipCount = columnTuple.getAndResetSkipCount();
        if (skipCount > 0) {
            this.writtenComponents.add(MergeColumnTupleWriter.setAntimatterIndicator(componentIndex), skipCount);
        }
        if (!columnTuple.isAntimatter()) {
            this.writtenComponents.add(componentIndex);
        } else {
            ++this.numberOfAntiMatter;
        }
        this.writePrimaryKeys(columnTuple);
    }

    public int flush(ByteBuffer pageZero) throws HyracksDataException {
        int numberOfColumns = this.columnMetadata.getNumberOfColumns();
        int numberOfPrimaryKeys = this.columnMetadata.getNumberOfPrimaryKeys();
        if (this.writtenComponents.getSize() > 0) {
            this.writeNonKeyColumns();
            this.writtenComponents.reset();
        }
        for (int i = numberOfPrimaryKeys; i < numberOfColumns; ++i) {
            this.orderedColumns.add(this.columnMetadata.getWriter(i));
        }
        this.writer.setPageZeroBuffer(pageZero, numberOfColumns, numberOfPrimaryKeys);
        int allocatedSpace = this.writer.writePrimaryKeyColumns(this.primaryKeyWriters);
        this.numberOfAntiMatter = 0;
        return allocatedSpace += this.writer.writeColumns(this.orderedColumns);
    }

    public void close() {
        this.columnMetadata.close();
    }

    private void writePrimaryKeys(MergeColumnTupleReference columnTuple) throws HyracksDataException {
        int primaryKeySize = 0;
        for (int i = 0; i < this.columnMetadata.getNumberOfPrimaryKeys(); ++i) {
            IColumnValuesReader columnReader = columnTuple.getReader(i);
            IColumnValuesWriter columnWriter = this.primaryKeyWriters[i];
            columnReader.write(columnWriter, false);
            primaryKeySize += columnWriter.getEstimatedSize();
        }
        this.primaryKeysEstimatedSize = primaryKeySize;
    }

    private void writeNonKeyColumns() throws HyracksDataException {
        for (int i = 0; i < this.writtenComponents.getNumberOfBlocks(); ++i) {
            int componentIndex = this.writtenComponents.getBlockValue(i);
            if (componentIndex < 0) {
                componentIndex = MergeColumnTupleWriter.clearAntimatterIndicator(componentIndex);
                this.skipReaders(componentIndex, this.writtenComponents.getBlockSize(i));
                continue;
            }
            MergeColumnTupleReference componentTuple = this.componentsTuples[componentIndex];
            int count = this.writtenComponents.getBlockSize(i);
            for (int j = this.columnMetadata.getNumberOfPrimaryKeys(); j < this.columnMetadata.getNumberOfColumns(); ++j) {
                IColumnValuesReader columnReader = componentTuple.getReader(j);
                IColumnValuesWriter columnWriter = this.columnMetadata.getWriter(j);
                this.writeColumn(i, componentIndex, columnReader, columnWriter, count);
            }
        }
    }

    private void writeColumn(int blockIndex, int componentIndex, IColumnValuesReader columnReader, IColumnValuesWriter columnWriter, int count) throws HyracksDataException {
        try {
            columnReader.write(columnWriter, count);
        }
        catch (ColumnarValueException e) {
            ObjectNode node = e.createNode(((Object)((Object)this)).getClass().getSimpleName());
            node.put("numberOfWrittenPrimaryKeys", this.primaryKeyWriters[0].getCount());
            node.put("writtenComponents", this.writtenComponents.toString());
            node.put("blockIndex", blockIndex);
            node.put("componentIndex", componentIndex);
            node.put("count", count);
            node.put("numberOFAntiMatters", this.numberOfAntiMatter);
            throw e;
        }
    }

    private void skipReaders(int componentIndex, int count) throws HyracksDataException {
        MergeColumnTupleReference componentTuple = this.componentsTuples[componentIndex];
        for (int j = this.columnMetadata.getNumberOfPrimaryKeys(); j < this.columnMetadata.getNumberOfColumns(); ++j) {
            IColumnValuesReader columnReader = componentTuple.getReader(j);
            columnReader.skip(count);
        }
    }

    private void writeAllColumns(MergeColumnTupleReference columnTuple) throws HyracksDataException {
        int skipCount = columnTuple.getAndResetSkipCount();
        if (skipCount > 0) {
            this.writtenComponents.add(MergeColumnTupleWriter.setAntimatterIndicator(columnTuple.getComponentIndex()), skipCount);
        }
        this.writeNonKeyColumns();
        this.writtenComponents.reset();
    }

    private static int setAntimatterIndicator(int componentIndex) {
        return -(componentIndex + 1);
    }

    private static int clearAntimatterIndicator(int componentIndex) {
        return -componentIndex - 1;
    }

    private int getMaxNumberOfTuples(int maxNumberOfTuples, int totalNumberOfTuples, int totalLength) {
        int numberOfTuplesUsingMaxSize = Integer.MAX_VALUE;
        if (totalLength > this.maxLeafNodeSize && totalNumberOfTuples > 0) {
            int bytesPerTuple = (int)Math.ceil((double)totalLength / (double)totalNumberOfTuples);
            numberOfTuplesUsingMaxSize = this.maxLeafNodeSize / bytesPerTuple;
        }
        return Math.min(maxNumberOfTuples, numberOfTuplesUsingMaxSize);
    }
}

