/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.tuple;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.column.assembler.value.IValueGetter;
import org.apache.asterix.column.assembler.value.ValueGetterFactory;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.asterix.column.bytes.stream.in.ByteBufferInputStream;
import org.apache.asterix.column.bytes.stream.in.DummyBytesInputStream;
import org.apache.asterix.column.bytes.stream.in.MultiByteBufferInputStream;
import org.apache.asterix.column.values.reader.PrimitiveColumnValuesReader;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleMode;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleNoExactMatchPolicy;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnBufferProvider;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnReadMultiPageOp;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnTupleIterator;
import org.apache.hyracks.storage.am.lsm.btree.column.api.projection.IColumnProjectionInfo;
import org.apache.hyracks.storage.am.lsm.btree.column.error.ColumnarValueException;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTreeReadLeafFrame;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm.tuples.AbstractColumnTupleReference;
import org.apache.hyracks.storage.common.MultiComparator;

public abstract class AbstractAsterixColumnTupleReference
extends AbstractColumnTupleReference {
    private final IValueGetter[] primaryKeysValueGetters;
    protected final ByteBufferInputStream[] primaryKeyStreams;
    protected final PrimitiveColumnValuesReader[] primaryKeyReaders;
    protected final VoidPointable[] primaryKeys;
    protected final AbstractBytesInputStream[] columnStreams;

    protected AbstractAsterixColumnTupleReference(int componentIndex, ColumnBTreeReadLeafFrame frame, IColumnProjectionInfo info, IColumnReadMultiPageOp multiPageOp) {
        super(componentIndex, frame, info, multiPageOp);
        int i;
        this.primaryKeyReaders = this.getPrimaryKeyReaders(info);
        int numberOfPrimaryKeys = this.primaryKeyReaders.length;
        this.primaryKeyStreams = new ByteBufferInputStream[numberOfPrimaryKeys];
        this.primaryKeysValueGetters = new IValueGetter[numberOfPrimaryKeys];
        this.primaryKeys = new VoidPointable[numberOfPrimaryKeys];
        for (i = 0; i < numberOfPrimaryKeys; ++i) {
            this.primaryKeyStreams[i] = new ByteBufferInputStream();
            this.primaryKeysValueGetters[i] = ValueGetterFactory.INSTANCE.createValueGetter(this.primaryKeyReaders[i].getTypeTag());
            this.primaryKeys[i] = new VoidPointable();
        }
        this.columnStreams = new AbstractBytesInputStream[info.getNumberOfProjectedColumns()];
        for (i = 0; i < this.columnStreams.length; ++i) {
            this.columnStreams[i] = info.getColumnIndex(i) >= numberOfPrimaryKeys ? new MultiByteBufferInputStream() : DummyBytesInputStream.INSTANCE;
        }
    }

    protected abstract PrimitiveColumnValuesReader[] getPrimaryKeyReaders(IColumnProjectionInfo var1);

    protected int setPrimaryKeysAt(int index, int skipCount) throws HyracksDataException {
        int numberOfSkippedAntiMatters = this.resetPrimaryKeyReader(0, index, skipCount);
        for (int i = 1; i < this.primaryKeyReaders.length; ++i) {
            this.resetPrimaryKeyReader(i, index, skipCount);
        }
        return skipCount - numberOfSkippedAntiMatters;
    }

    protected final void startPrimaryKey(IColumnBufferProvider provider, int ordinal, int numberOfTuples) throws HyracksDataException {
        ByteBufferInputStream primaryKeyStream = this.primaryKeyStreams[ordinal];
        primaryKeyStream.reset(provider);
        PrimitiveColumnValuesReader reader = this.primaryKeyReaders[ordinal];
        reader.reset(primaryKeyStream, numberOfTuples);
    }

    protected final void onNext() throws HyracksDataException {
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            PrimitiveColumnValuesReader reader = this.primaryKeyReaders[i];
            reader.next();
            this.primaryKeys[i].set(this.primaryKeysValueGetters[i].getValue(reader));
        }
    }

    public void lastTupleReached() throws HyracksDataException {
    }

    public final int getFieldCount() {
        return this.primaryKeys.length;
    }

    public final byte[] getFieldData(int fIdx) {
        return this.primaryKeys[fIdx].getByteArray();
    }

    public final int getFieldStart(int fIdx) {
        return this.primaryKeys[fIdx].getStartOffset();
    }

    public final int getFieldLength(int fIdx) {
        return this.primaryKeys[fIdx].getLength();
    }

    public final int getTupleSize() {
        return -1;
    }

    public final boolean isAntimatter() {
        return this.primaryKeyReaders[0].isMissing();
    }

    public final int compareTo(IColumnTupleIterator o) {
        AbstractAsterixColumnTupleReference other = (AbstractAsterixColumnTupleReference)o;
        int compare = 0;
        for (int i = 0; i < this.primaryKeys.length && compare == 0; ++i) {
            compare = this.primaryKeyReaders[i].compareTo(other.primaryKeyReaders[i]);
        }
        return compare;
    }

    public int findTupleIndex(ITupleReference searchKey, MultiComparator comparator, FindTupleMode mode, FindTupleNoExactMatchPolicy matchPolicy) throws HyracksDataException {
        int tupleCount = this.getTupleCount();
        if (tupleCount <= 0) {
            return -1;
        }
        int begin = this.tupleIndex;
        int end = tupleCount - 1;
        while (begin <= end) {
            int mid = (begin + end) / 2;
            this.setKeyAt(mid);
            int cmp = comparator.compare(searchKey, (ITupleReference)this);
            if (cmp < 0) {
                end = mid - 1;
                continue;
            }
            if (cmp > 0) {
                begin = mid + 1;
                continue;
            }
            if (mode == FindTupleMode.EXCLUSIVE) {
                if (matchPolicy == FindTupleNoExactMatchPolicy.HIGHER_KEY) {
                    begin = mid + 1;
                    continue;
                }
                end = mid - 1;
                continue;
            }
            if (mode == FindTupleMode.EXCLUSIVE_ERROR_IF_EXISTS) {
                return -2;
            }
            return mid;
        }
        if (mode == FindTupleMode.EXACT) {
            return -2;
        }
        if (matchPolicy == FindTupleNoExactMatchPolicy.HIGHER_KEY) {
            if (begin > tupleCount - 1) {
                return -1;
            }
            this.setKeyAt(begin);
            if (comparator.compare(searchKey, (ITupleReference)this) < 0) {
                return begin;
            }
            return -1;
        }
        if (end < 0) {
            return -1;
        }
        this.setKeyAt(end);
        if (comparator.compare(searchKey, (ITupleReference)this) > 0) {
            return end;
        }
        return -1;
    }

    protected void setKeyAt(int index) {
        for (int i = 0; i < this.primaryKeyReaders.length; ++i) {
            PrimitiveColumnValuesReader reader = this.primaryKeyReaders[i];
            reader.getValue(index);
            this.primaryKeys[i].set(this.primaryKeysValueGetters[i].getValue(reader));
        }
    }

    protected void appendExceptionInformation(ColumnarValueException e, int previousIndex) {
        ObjectNode node = e.createNode(((Object)((Object)this)).getClass().getSimpleName());
        node.put("isAntiMatter", this.isAntimatter());
        node.put("previousIndex", previousIndex);
        ArrayNode pkNodes = node.putArray("primaryKeyReaders");
        for (PrimitiveColumnValuesReader reader : this.primaryKeyReaders) {
            reader.appendReaderInformation(pkNodes.addObject());
        }
    }

    private int resetPrimaryKeyReader(int i, int index, int skipCount) throws HyracksDataException {
        PrimitiveColumnValuesReader reader = this.primaryKeyReaders[i];
        int numberOfSkippedAntiMatters = reader.reset(index, skipCount);
        this.primaryKeys[i].set(this.primaryKeysValueGetters[i].getValue(reader));
        return numberOfSkippedAntiMatters + (this.isAntimatter() ? 1 : 0);
    }
}

