/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.values.writer.filters;

import org.apache.asterix.column.values.writer.filters.LongColumnFilterWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class StringColumnFilterWriter
extends LongColumnFilterWriter {
    @Override
    public void addValue(IValueReference value) throws HyracksDataException {
        this.addLong(StringColumnFilterWriter.normalize(value));
    }

    public static long normalize(IValueReference value) {
        byte[] bytes = value.getByteArray();
        int start = value.getStartOffset();
        long nk = 0L;
        int offset = start + UTF8StringUtil.getNumBytesToStoreLength((int)UTF8StringUtil.getUTFLength((byte[])bytes, (int)start));
        int end = start + value.getLength();
        for (int i = 0; i < 4; ++i) {
            nk <<= 16;
            if (offset >= end) continue;
            nk += (long)(UTF8StringUtil.charAt((byte[])bytes, (int)offset) & 0xFFFF);
            offset += UTF8StringUtil.charSize((byte[])bytes, (int)offset);
        }
        return nk >>> 1;
    }
}

