/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.metadata.RMIClientFactory;
import org.apache.asterix.metadata.RMIServerFactory;
import org.apache.asterix.metadata.api.IAsterixStateProxy;
import org.apache.asterix.metadata.api.IMetadataNode;
import org.apache.hyracks.api.network.INetworkSecurityManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsterixStateProxy
implements IAsterixStateProxy {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private IMetadataNode metadataNode;
    private static IAsterixStateProxy cc;

    public static IAsterixStateProxy registerRemoteObject(INetworkSecurityManager networkSecurityManager, int metadataCallbackPort) throws RemoteException {
        cc = new AsterixStateProxy();
        IAsterixStateProxy stub = (IAsterixStateProxy)UnicastRemoteObject.exportObject(cc, metadataCallbackPort, RMIClientFactory.getSocketFactory(networkSecurityManager), RMIServerFactory.getSocketFactory(networkSecurityManager));
        LOGGER.info("Asterix Distributed State Proxy Bound");
        return stub;
    }

    public static void unregisterRemoteObject() throws RemoteException {
        if (cc != null) {
            UnicastRemoteObject.unexportObject(cc, true);
            LOGGER.info("Asterix Distributed State Proxy Unbound");
        }
    }

    @Override
    public synchronized void setMetadataNode(IMetadataNode metadataNode) {
        this.metadataNode = metadataNode;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMetadataNode waitForMetadataNode(long waitFor, TimeUnit timeUnit) throws InterruptedException {
        AsterixStateProxy asterixStateProxy = this;
        synchronized (asterixStateProxy) {
            long startTime;
            for (long timeToWait = TimeUnit.MILLISECONDS.convert(waitFor, timeUnit); this.metadataNode == null && timeToWait > 0L; timeToWait -= System.currentTimeMillis() - startTime) {
                startTime = System.currentTimeMillis();
                this.wait(timeToWait);
            }
            return this.metadataNode;
        }
    }
}

