/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.List;
import org.apache.asterix.metadata.bootstrap.MetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public final class DatabaseEntity {
    private static final DatabaseEntity DATABASE = new DatabaseEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_DATABASE, 2, new IAType[]{BuiltinType.ASTRING}, List.of(List.of("DatabaseName")), 0, DatabaseEntity.databaseType(), true, new int[]{0}), 1, 0);
    private final int payloadPosition;
    private final MetadataIndex index;
    private final int databaseNameIndex;
    private final int systemDatabaseIndex;
    private final int timestampIndex;
    private final int pendingOpIndex;

    private DatabaseEntity(MetadataIndex index, int payloadPosition, int startIndex) {
        this.index = index;
        this.payloadPosition = payloadPosition;
        this.databaseNameIndex = startIndex++;
        this.systemDatabaseIndex = startIndex++;
        this.timestampIndex = startIndex++;
        this.pendingOpIndex = startIndex++;
    }

    public static DatabaseEntity of(boolean cloudDeployment) {
        return DATABASE;
    }

    public MetadataIndex getIndex() {
        return this.index;
    }

    public ARecordType getRecordType() {
        return this.index.getPayloadRecordType();
    }

    public int payloadPosition() {
        return this.payloadPosition;
    }

    public int databaseNameIndex() {
        return this.databaseNameIndex;
    }

    public int systemDatabaseIndex() {
        return this.systemDatabaseIndex;
    }

    public int timestampIndex() {
        return this.timestampIndex;
    }

    public int pendingOpIndex() {
        return this.pendingOpIndex;
    }

    private static ARecordType databaseType() {
        return MetadataRecordTypes.createRecordType("DatabaseRecordType", new String[]{"DatabaseName", "SystemDatabase", "Timestamp", "PendingOp"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ABOOLEAN, BuiltinType.ASTRING, BuiltinType.AINT32}, true);
    }
}

