/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.Arrays;
import java.util.List;
import org.apache.asterix.metadata.bootstrap.MetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public final class IndexEntity {
    private static final IndexEntity INDEX = new IndexEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_INDEX, 4, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DataverseName"), List.of("DatasetName"), List.of("IndexName")), 0, IndexEntity.indexType(), true, new int[]{0, 1, 2}), 3, -1);
    private static final IndexEntity DB_INDEX = new IndexEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_INDEX, 5, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DatabaseName"), List.of("DataverseName"), List.of("DatasetName"), List.of("IndexName")), 0, IndexEntity.databaseIndexType(), true, new int[]{0, 1, 2, 3}), 4, 0);
    private final int payloadPosition;
    private final MetadataIndex index;
    private final int databaseNameIndex;
    private final int dataverseNameIndex;
    private final int datasetNameIndex;
    private final int indexNameIndex;
    private final int indexStructureIndex;
    private final int searchKeyIndex;
    private final int isPrimaryIndex;
    private final int timestampIndex;
    private final int pendingOpIndex;

    private IndexEntity(MetadataIndex index, int payloadPosition, int startIndex) {
        this.index = index;
        this.payloadPosition = payloadPosition;
        this.databaseNameIndex = startIndex++;
        this.dataverseNameIndex = startIndex++;
        this.datasetNameIndex = startIndex++;
        this.indexNameIndex = startIndex++;
        this.indexStructureIndex = startIndex++;
        this.searchKeyIndex = startIndex++;
        this.isPrimaryIndex = startIndex++;
        this.timestampIndex = startIndex++;
        this.pendingOpIndex = startIndex++;
    }

    public static IndexEntity of(boolean usingDatabase) {
        return usingDatabase ? DB_INDEX : INDEX;
    }

    public MetadataIndex getIndex() {
        return this.index;
    }

    public ARecordType getRecordType() {
        return this.index.getPayloadRecordType();
    }

    public int payloadPosition() {
        return this.payloadPosition;
    }

    public int databaseNameIndex() {
        return this.databaseNameIndex;
    }

    public int dataverseNameIndex() {
        return this.dataverseNameIndex;
    }

    public int datasetNameIndex() {
        return this.datasetNameIndex;
    }

    public int indexNameIndex() {
        return this.indexNameIndex;
    }

    public int indexStructureIndex() {
        return this.indexStructureIndex;
    }

    public int searchKeyIndex() {
        return this.searchKeyIndex;
    }

    public int isPrimaryIndex() {
        return this.isPrimaryIndex;
    }

    public int timestampIndex() {
        return this.timestampIndex;
    }

    public int pendingOpIndex() {
        return this.pendingOpIndex;
    }

    private static ARecordType indexType() {
        return MetadataRecordTypes.createRecordType("IndexRecordType", new String[]{"DataverseName", "DatasetName", "IndexName", "IndexStructure", "SearchKey", "IsPrimary", "Timestamp", "PendingOp"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, new AOrderedListType((IAType)new AOrderedListType((IAType)BuiltinType.ASTRING, null), null), BuiltinType.ABOOLEAN, BuiltinType.ASTRING, BuiltinType.AINT32}, true);
    }

    private static ARecordType databaseIndexType() {
        return MetadataRecordTypes.createRecordType("IndexRecordType", new String[]{"DatabaseName", "DataverseName", "DatasetName", "IndexName", "IndexStructure", "SearchKey", "IsPrimary", "Timestamp", "PendingOp"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, new AOrderedListType((IAType)new AOrderedListType((IAType)BuiltinType.ASTRING, null), null), BuiltinType.ABOOLEAN, BuiltinType.ASTRING, BuiltinType.AINT32}, true);
    }
}

