/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.List;
import org.apache.asterix.metadata.bootstrap.MetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public final class NodeGroupEntity {
    private static final NodeGroupEntity NODE_GROUP = new NodeGroupEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_NODEGROUP, 2, new IAType[]{BuiltinType.ASTRING}, List.of(List.of("GroupName")), 0, NodeGroupEntity.nodeGroupType(), true, new int[]{0}), 1, -1);
    private final int payloadPosition;
    private final MetadataIndex index;
    private final int databaseNameIndex;
    private final int groupNameIndex;
    private final int nodeNamesIndex;
    private final int timestampIndex;

    private NodeGroupEntity(MetadataIndex index, int payloadPosition, int startIndex) {
        this.index = index;
        this.payloadPosition = payloadPosition;
        this.databaseNameIndex = startIndex++;
        this.groupNameIndex = startIndex++;
        this.nodeNamesIndex = startIndex++;
        this.timestampIndex = startIndex++;
    }

    public static NodeGroupEntity of(boolean cloudDeployment) {
        return NODE_GROUP;
    }

    public MetadataIndex getIndex() {
        return this.index;
    }

    public ARecordType getRecordType() {
        return this.index.getPayloadRecordType();
    }

    public int payloadPosition() {
        return this.payloadPosition;
    }

    public int databaseNameIndex() {
        return this.databaseNameIndex;
    }

    public int groupNameIndex() {
        return this.groupNameIndex;
    }

    public int nodeNamesIndex() {
        return this.nodeNamesIndex;
    }

    public int timestampIndex() {
        return this.timestampIndex;
    }

    private static ARecordType nodeGroupType() {
        return MetadataRecordTypes.createRecordType("NodeGroupRecordType", new String[]{"GroupName", "NodeNames", "Timestamp"}, new IAType[]{BuiltinType.ASTRING, new AUnorderedListType((IAType)BuiltinType.ASTRING, null), BuiltinType.ASTRING}, true);
    }
}

