/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.distribution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.teradata.tpcds.distribution.DistributionUtils;
import com.teradata.tpcds.random.RandomNumberStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FipsCountyDistribution {
    private static final FipsCountyDistribution FIPS_COUNTY_DISTRIBUTION = FipsCountyDistribution.buildFipsCountyDistribution();
    private static final String VALUES_AND_WEIGHTS_FILENAME = "fips.dst";
    private static final int NUM_WEIGHT_FIELDS = 6;
    private final ImmutableList<String> counties;
    private final ImmutableList<String> stateAbbreviations;
    private final ImmutableList<Integer> zipPrefixes;
    private final ImmutableList<Integer> gmtOffsets;
    private final ImmutableList<ImmutableList<Integer>> weightsLists;

    public FipsCountyDistribution(ImmutableList<String> counties, ImmutableList<String> stateAbbreviations, ImmutableList<Integer> zipPrefixes, ImmutableList<Integer> gmtOffsets, ImmutableList<ImmutableList<Integer>> weightsLists) {
        this.counties = counties;
        this.stateAbbreviations = stateAbbreviations;
        this.zipPrefixes = zipPrefixes;
        this.gmtOffsets = gmtOffsets;
        this.weightsLists = weightsLists;
    }

    public static FipsCountyDistribution buildFipsCountyDistribution() {
        ImmutableList.Builder countiesBuilder = ImmutableList.builder();
        ImmutableList.Builder stateAbbreviationsBuilder = ImmutableList.builder();
        ImmutableList.Builder zipPrefixesBuilder = ImmutableList.builder();
        ImmutableList.Builder gmtOffsetsBuilder = ImmutableList.builder();
        ArrayList<DistributionUtils.WeightsBuilder> weightsBuilders = new ArrayList<DistributionUtils.WeightsBuilder>(6);
        for (int i = 0; i < 6; ++i) {
            weightsBuilders.add(new DistributionUtils.WeightsBuilder());
        }
        Iterator<List<String>> iterator = DistributionUtils.getDistributionIterator(VALUES_AND_WEIGHTS_FILENAME);
        while (iterator.hasNext()) {
            List<String> fields = iterator.next();
            Preconditions.checkState((fields.size() == 2 ? 1 : 0) != 0, (String)"Expected line to contain 2 parts but it contains %d: %s", (Object[])new Object[]{fields.size(), fields});
            List<String> values = DistributionUtils.getListFromCommaSeparatedValues(fields.get(0));
            Preconditions.checkState((values.size() == 6 ? 1 : 0) != 0, (String)"Expected line to contain 6 values, but it contained %d, %s", (Object[])new Object[]{values.size(), values});
            countiesBuilder.add((Object)values.get(1));
            stateAbbreviationsBuilder.add((Object)values.get(2));
            zipPrefixesBuilder.add((Object)Integer.parseInt(values.get(4)));
            gmtOffsetsBuilder.add((Object)Integer.parseInt(values.get(5)));
            List<String> weights = DistributionUtils.getListFromCommaSeparatedValues(fields.get(1));
            Preconditions.checkState((weights.size() == 6 ? 1 : 0) != 0, (String)"Expected line to contain %d weights, but it contained %d, %s", (Object[])new Object[]{6, weights.size(), values});
            for (int i = 0; i < weights.size(); ++i) {
                ((DistributionUtils.WeightsBuilder)weightsBuilders.get(i)).computeAndAddNextWeight(Integer.valueOf(weights.get(i)));
            }
        }
        ImmutableList.Builder weightsListBuilder = ImmutableList.builder();
        for (DistributionUtils.WeightsBuilder weightsBuilder : weightsBuilders) {
            weightsListBuilder.add(weightsBuilder.build());
        }
        return new FipsCountyDistribution((ImmutableList<String>)countiesBuilder.build(), (ImmutableList<String>)stateAbbreviationsBuilder.build(), (ImmutableList<Integer>)zipPrefixesBuilder.build(), (ImmutableList<Integer>)gmtOffsetsBuilder.build(), (ImmutableList<ImmutableList<Integer>>)weightsListBuilder.build());
    }

    public static int pickRandomIndex(FipsWeights weights, RandomNumberStream stream) {
        return DistributionUtils.pickRandomIndex((List)FipsCountyDistribution.FIPS_COUNTY_DISTRIBUTION.weightsLists.get(weights.ordinal()), stream);
    }

    public static String getCountyAtIndex(int index) {
        return (String)FipsCountyDistribution.FIPS_COUNTY_DISTRIBUTION.counties.get(index);
    }

    public static String getStateAbbreviationAtIndex(int index) {
        return (String)FipsCountyDistribution.FIPS_COUNTY_DISTRIBUTION.stateAbbreviations.get(index);
    }

    public static int getZipPrefixAtIndex(int index) {
        return (Integer)FipsCountyDistribution.FIPS_COUNTY_DISTRIBUTION.zipPrefixes.get(index);
    }

    public static int getGmtOffsetAtIndex(int index) {
        return (Integer)FipsCountyDistribution.FIPS_COUNTY_DISTRIBUTION.gmtOffsets.get(index);
    }

    public static enum FipsWeights {
        UNIFORM,
        POPULATION,
        TIMEZONE,
        IN_ZONE_1,
        IN_ZONE_2,
        IN_ZONE_3;

    }
}

