/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.util;

import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;

public class DataUtils {
    private DataUtils() {
    }

    public static void copyInto(IValueReference value, byte[] copy) {
        System.arraycopy(value.getByteArray(), value.getStartOffset(), copy, 0, value.getLength());
    }

    public static void copyInto(IValueReference value, byte[] copy, int offset) {
        System.arraycopy(value.getByteArray(), value.getStartOffset(), copy, offset, value.getLength());
    }

    public static boolean equals(IValueReference first, IValueReference second) {
        if (first.getLength() != second.getLength()) {
            return false;
        }
        return DataUtils.equalsInRange(first.getByteArray(), first.getStartOffset(), second.getByteArray(), second.getStartOffset(), first.getLength());
    }

    public static boolean equalsInRange(byte[] arr1, int offset1, byte[] arr2, int offset2, int length) {
        for (int i = 0; i < length; ++i) {
            if (arr1[offset1 + i] == arr2[offset2 + i]) continue;
            return false;
        }
        return true;
    }

    public static int compare(IValueReference first, IValueReference second, IBinaryComparator cmp) throws HyracksDataException {
        return cmp.compare(first.getByteArray(), first.getStartOffset(), first.getLength(), second.getByteArray(), second.getStartOffset(), second.getLength());
    }

    public static void ensureLengths(int requiredLength, int length1, int length2) {
        if (length1 != requiredLength || length2 != requiredLength) {
            throw new IllegalStateException();
        }
    }
}

