/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.transaction;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.transaction.management.service.transaction.AbstractTransactionContext;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.common.IModificationOperationCallback;

public class EntityLevelTransactionContext
extends AbstractTransactionContext {
    private final Map<Integer, Pair<PrimaryIndexOperationTracker, IModificationOperationCallback>> primaryIndexTrackers = new ConcurrentHashMap<Integer, Pair<PrimaryIndexOperationTracker, IModificationOperationCallback>>();
    private final Map<Long, AtomicInteger> resourcePendingOps = new ConcurrentHashMap<Long, AtomicInteger>();
    private final Map<Integer, AtomicInteger> partitionPendingOps = new ConcurrentHashMap<Integer, AtomicInteger>();

    public EntityLevelTransactionContext(TxnId txnId) {
        super(txnId);
    }

    @Override
    public void register(long resourceId, int partition, ILSMIndex index, IModificationOperationCallback callback, boolean primaryIndex) {
        super.register(resourceId, partition, index, callback, primaryIndex);
        AtomicInteger pendingOps = this.partitionPendingOps.computeIfAbsent(partition, p -> new AtomicInteger(0));
        this.resourcePendingOps.put(resourceId, pendingOps);
        if (primaryIndex) {
            Pair pair = new Pair((Object)((PrimaryIndexOperationTracker)index.getOperationTracker()), (Object)callback);
            this.primaryIndexTrackers.put(partition, (Pair<PrimaryIndexOperationTracker, IModificationOperationCallback>)pair);
        }
    }

    public void beforeOperation(long resourceId) {
        this.resourcePendingOps.get(resourceId).incrementAndGet();
    }

    public void notifyEntityCommitted(int partition) {
        try {
            Pair<PrimaryIndexOperationTracker, IModificationOperationCallback> pair = this.primaryIndexTrackers.get(partition);
            ((PrimaryIndexOperationTracker)pair.first).completeOperation(null, LSMOperationType.MODIFICATION, null, (IModificationOperationCallback)pair.second);
        }
        catch (HyracksDataException e) {
            throw new ACIDException((Throwable)e);
        }
    }

    public void afterOperation(long resourceId) {
        this.resourcePendingOps.get(resourceId).decrementAndGet();
    }

    @Override
    protected void cleanup() {
        if (this.getTxnState() == 2) {
            this.primaryIndexTrackers.forEach((partitionId, opTracker) -> {
                int pendingOps = this.partitionPendingOps.get(partitionId).intValue();
                for (int i = 0; i < pendingOps; ++i) {
                    try {
                        ((PrimaryIndexOperationTracker)opTracker.first).completeOperation(null, LSMOperationType.MODIFICATION, null, (IModificationOperationCallback)opTracker.second);
                        continue;
                    }
                    catch (HyracksDataException ex) {
                        throw new ACIDException((Throwable)ex);
                    }
                }
            });
        }
    }

    public int hashCode() {
        return Long.hashCode(this.txnId.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityLevelTransactionContext that = (EntityLevelTransactionContext)o;
        return this.txnId.equals((Object)that.txnId);
    }

    public boolean hasWAL() {
        return true;
    }
}

