/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.filter.embedder;

import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.dataflow.data.nontagged.serde.AStringSerializerDeserializer;
import org.apache.asterix.external.input.filter.ExternalFilterValueEvaluator;
import org.apache.asterix.external.util.ExternalDataPrefix;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ProjectionFiltrationTypeUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.util.string.UTF8StringWriter;

class EmbeddedValueBuilder {
    private final ARecordType allPaths;
    private final ExternalDataPrefix prefix;
    private final Map<IAType, BitSet> setValues;
    private final Stack<RecordBuilder> recordBuilders;
    private final Map<IAType, ArrayBackedValueStorage> embeddedValues;
    private final Map<String, IValueReference> fieldNames;
    private final AStringSerializerDeserializer stringSerDer;

    EmbeddedValueBuilder(ARecordType allPaths, ExternalDataPrefix prefix, Map<IAType, BitSet> setValues) {
        this.allPaths = allPaths;
        this.prefix = prefix;
        this.setValues = setValues;
        this.recordBuilders = new Stack();
        this.embeddedValues = new HashMap<IAType, ArrayBackedValueStorage>();
        this.fieldNames = new HashMap<String, IValueReference>();
        this.stringSerDer = new AStringSerializerDeserializer(new UTF8StringWriter());
        setValues.put((IAType)allPaths, new BitSet(allPaths.getFieldTypes().length));
    }

    void build(String path) throws HyracksDataException {
        List<String> values = this.prefix.getValues(this.prefix.removeProtocolContainerPair(path));
        this.build(this.allPaths, values);
    }

    IValueReference getValue(IAType type) {
        return (IValueReference)this.embeddedValues.get(type);
    }

    private IValueReference build(ARecordType recordType, List<String> values) throws HyracksDataException {
        RecordBuilder recordBuilder = this.getOrCreateRecordBuilder(recordType);
        String[] fieldNames = recordType.getFieldNames();
        IAType[] fieldTypes = recordType.getFieldTypes();
        for (int i = 0; i < fieldTypes.length; ++i) {
            IValueReference valueRef = this.getValue(fieldTypes[i], values);
            IValueReference fieldNameRef = this.getOrCreateFieldName(fieldNames[i]);
            recordBuilder.addField(fieldNameRef, valueRef);
        }
        ArrayBackedValueStorage storage = this.getOrCreateValueStorage((IAType)recordType);
        recordBuilder.write(storage.getDataOutput(), true);
        this.recordBuilders.push(recordBuilder);
        return storage;
    }

    private IValueReference build(IAType flatType, List<String> values) throws HyracksDataException {
        ProjectionFiltrationTypeUtil.RenamedType leaf = (ProjectionFiltrationTypeUtil.RenamedType)flatType;
        ArrayBackedValueStorage storage = this.getOrCreateValueStorage(flatType);
        ATypeTag typeTag = this.prefix.getComputedFieldTypes().get(leaf.getIndex()).getTypeTag();
        ExternalFilterValueEvaluator.writeValue(typeTag, values.get(leaf.getIndex()), storage, this.stringSerDer);
        return storage;
    }

    private IValueReference getValue(IAType type, List<String> values) throws HyracksDataException {
        ATypeTag typeTag = type.getTypeTag();
        if (typeTag == ATypeTag.OBJECT) {
            return this.build((ARecordType)type, values);
        }
        return this.build(type, values);
    }

    private RecordBuilder getOrCreateRecordBuilder(ARecordType recordType) {
        RecordBuilder recordBuilder;
        if (this.recordBuilders.isEmpty()) {
            recordBuilder = new RecordBuilder();
            this.setValues.put((IAType)recordType, new BitSet(recordType.getFieldTypes().length));
        } else {
            recordBuilder = this.recordBuilders.pop();
        }
        recordBuilder.reset(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        return recordBuilder;
    }

    private ArrayBackedValueStorage getOrCreateValueStorage(IAType type) {
        ArrayBackedValueStorage storage = this.embeddedValues.computeIfAbsent(type, k -> new ArrayBackedValueStorage());
        storage.reset();
        return storage;
    }

    private IValueReference getOrCreateFieldName(String fieldName) throws HyracksDataException {
        IValueReference fieldNameRef = this.fieldNames.get(fieldName);
        if (fieldNameRef == null) {
            ArrayBackedValueStorage storage = new ArrayBackedValueStorage();
            EmbeddedValueBuilder.serializeTag(ATypeTag.STRING, storage);
            this.stringSerDer.serialize(fieldName, storage.getDataOutput());
            fieldNameRef = storage;
            this.fieldNames.put(fieldName, fieldNameRef);
        }
        return fieldNameRef;
    }

    private static void serializeTag(ATypeTag tag, ArrayBackedValueStorage storage) throws HyracksDataException {
        try {
            storage.getDataOutput().writeByte(tag.serialize());
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

