/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested;

import java.io.IOException;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.external.input.filter.embedder.IExternalFilterValueEmbedder;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.IFieldValue;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.ParquetConverterContext;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested.AbstractComplexConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested.ArrayConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.PrimitiveConverterProvider;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.PrimitiveType;

class ObjectConverter
extends AbstractComplexConverter {
    private IARecordBuilder builder;
    private boolean ignore = false;

    public ObjectConverter(AbstractComplexConverter parent, int index, GroupType parquetType, ParquetConverterContext context) throws IOException {
        super(parent, index, parquetType, context);
    }

    public ObjectConverter(AbstractComplexConverter parent, String stringFieldName, int index, GroupType parquetType, ParquetConverterContext context) throws IOException {
        super(parent, stringFieldName, index, parquetType, context);
    }

    public void start() {
        this.tempStorage = this.context.enterObject();
        this.builder = this.context.getObjectBuilder(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        IExternalFilterValueEmbedder valueEmbedder = this.context.getValueEmbedder();
        if (this.isRoot()) {
            valueEmbedder.reset();
            valueEmbedder.enterObject();
        } else {
            this.ignore = this.checkValueEmbedder(valueEmbedder);
        }
    }

    public void end() {
        if (!this.ignore) {
            this.writeToParent();
            this.context.getValueEmbedder().exitObject();
        }
        this.context.exitObject(this.tempStorage, null, this.builder);
        this.tempStorage = null;
        this.builder = null;
        this.ignore = false;
    }

    @Override
    public ATypeTag getTypeTag() {
        return ATypeTag.OBJECT;
    }

    @Override
    public void addValue(IFieldValue value) {
        if (this.ignore) {
            return;
        }
        IExternalFilterValueEmbedder valueEmbedder = this.context.getValueEmbedder();
        IValueReference fieldName = value.getFieldName();
        try {
            if (valueEmbedder.shouldEmbed(value.getStringFieldName(), value.getTypeTag())) {
                this.builder.addField(fieldName, valueEmbedder.getEmbeddedValue());
            } else {
                this.builder.addField(fieldName, (IValueReference)this.getValue());
            }
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected PrimitiveConverter createAtomicConverter(GroupType type, int index) {
        try {
            PrimitiveType primitiveType = type.getType(index).asPrimitiveType();
            String childFieldName = type.getFieldName(index);
            return PrimitiveConverterProvider.createPrimitiveConverter(primitiveType, this, childFieldName, index, this.context);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected ArrayConverter createArrayConverter(GroupType type, int index) {
        try {
            GroupType arrayType = type.getType(index).asGroupType();
            String childFieldName = type.getFieldName(index);
            return new ArrayConverter(this, childFieldName, index, arrayType, this.context);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected ObjectConverter createObjectConverter(GroupType type, int index) {
        try {
            GroupType objectType = type.getType(index).asGroupType();
            String childFieldName = type.getFieldName(index);
            return new ObjectConverter(this, childFieldName, index, objectType, this.context);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected boolean isRoot() {
        return false;
    }

    private boolean checkValueEmbedder(IExternalFilterValueEmbedder valueEmbedder) {
        boolean embed = valueEmbedder.shouldEmbed(this.getStringFieldName(), ATypeTag.OBJECT);
        if (embed) {
            ((ArrayBackedValueStorage)this.parent.getValue()).set(valueEmbedder.getEmbeddedValue());
            this.addThisValueToParent();
        } else {
            valueEmbedder.enterObject();
        }
        return embed;
    }

    private void writeToParent() {
        try {
            this.finalizeEmbedding();
            this.builder.write(this.getParentDataOutput(), true);
            this.addThisValueToParent();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void finalizeEmbedding() throws IOException {
        IExternalFilterValueEmbedder valueEmbedder = this.context.getValueEmbedder();
        if (valueEmbedder.isMissingEmbeddedValues()) {
            String[] embeddedFieldNames = valueEmbedder.getEmbeddedFieldNames();
            for (int i = 0; i < embeddedFieldNames.length; ++i) {
                String embeddedFieldName = embeddedFieldNames[i];
                if (!valueEmbedder.isMissing(embeddedFieldName)) continue;
                IValueReference embeddedValue = valueEmbedder.getEmbeddedValue();
                this.builder.addField((IValueReference)this.context.getSerializedFieldName(embeddedFieldName), embeddedValue);
            }
        }
    }
}

