/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.ipc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.api.IExternalLangIPCProto;
import org.apache.asterix.external.ipc.AbstractPythonIPCProto;
import org.apache.asterix.external.ipc.MessageType;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.msgpack.core.buffer.MessageBufferInput;

public class PythonDomainSocketProto
extends AbstractPythonIPCProto
implements IExternalLangIPCProto {
    private final String wd;
    SocketChannel chan;
    private ByteBuffer headerBuffer;
    private ProcessHandle pid;
    public static final int HYR_HEADER_SIZE = 21;
    public static final int HYR_HEADER_SIZE_NOSZ = 17;

    public PythonDomainSocketProto(OutputStream sockOut, SocketChannel chan, String wd) {
        super(sockOut);
        this.chan = chan;
        this.wd = wd;
        this.headerBuffer = ByteBuffer.allocate(21);
    }

    @Override
    public void start() {
    }

    @Override
    public void helo() throws IOException, AsterixException {
        this.recvBuffer.clear();
        this.recvBuffer.position(0);
        this.recvBuffer.limit(0);
        this.messageBuilder.reset();
        this.messageBuilder.helloDS(this.wd);
        this.sendHeader(this.routeId, this.messageBuilder.getLength());
        this.sendMsg(true);
        this.receiveMsg(true);
        byte pidType = this.recvBuffer.get();
        if (pidType != -50 && pidType != -51) {
            throw AsterixException.create((org.apache.asterix.common.exceptions.ErrorCode)org.apache.asterix.common.exceptions.ErrorCode.EXTERNAL_UDF_EXCEPTION, (Serializable[])new Serializable[]{"Returned pid type is incorrect: " + pidType});
        }
        switch (pidType) {
            case -50: {
                this.pid = ProcessHandle.of(this.recvBuffer.getInt()).get();
                break;
            }
            case -51: {
                this.pid = ProcessHandle.of(this.recvBuffer.getShort()).get();
                break;
            }
            case -52: {
                this.pid = ProcessHandle.of(this.recvBuffer.get()).get();
                break;
            }
            default: {
                throw AsterixException.create((org.apache.asterix.common.exceptions.ErrorCode)org.apache.asterix.common.exceptions.ErrorCode.EXTERNAL_UDF_EXCEPTION, (Serializable[])new Serializable[]{"Returned pid type is incorrect: " + pidType});
            }
        }
        if (this.getResponseType() != MessageType.HELO) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"Expected HELO, recieved " + this.getResponseType().name()});
        }
    }

    @Override
    public void sendMsg() throws IOException {
        this.sendMsg(false);
    }

    @Override
    public void sendMsg(ArrayBackedValueStorage args) throws IOException {
        this.sendMsg(false, args);
    }

    public void sendMsg(boolean sendIfDead) throws IOException {
        if (!(sendIfDead || this.pid != null && this.pid.isAlive())) {
            return;
        }
        super.sendMsg();
    }

    public void sendMsg(boolean sendIfDead, ArrayBackedValueStorage args) throws IOException {
        if (!(sendIfDead || this.pid != null && this.pid.isAlive())) {
            return;
        }
        super.sendMsg(args);
    }

    @Override
    public void receiveMsg() throws IOException, AsterixException {
        this.receiveMsg(false);
    }

    public void receiveMsg(boolean sendIfDead) throws IOException, AsterixException {
        if (!(sendIfDead || this.pid != null && this.pid.isAlive())) {
            throw new AsterixException("Python process exited unexpectedly");
        }
        this.readFully(this.headerBuffer.capacity(), this.headerBuffer);
        if (this.headerBuffer.remaining() < 4) {
            this.recvBuffer.limit(0);
            throw new AsterixException("Python process exited unexpectedly");
        }
        int msgSz = this.headerBuffer.getInt() - 17;
        if (this.recvBuffer.capacity() < msgSz) {
            this.recvBuffer = ByteBuffer.allocate((msgSz / 32768 + 1) * 32768);
        }
        this.readFully(msgSz, this.recvBuffer);
        this.messageBuilder.readHead(this.recvBuffer);
        if (this.messageBuilder.type == MessageType.ERROR) {
            this.unpackerInput.reset(this.recvBuffer.array(), this.recvBuffer.position() + this.recvBuffer.arrayOffset(), this.recvBuffer.remaining());
            this.unpacker.reset((MessageBufferInput)this.unpackerInput);
            throw new AsterixException(this.unpacker.unpackString().replace('\u0000', ' '));
        }
    }

    private void readFully(int msgSz, ByteBuffer buf) throws IOException, AsterixException {
        int read;
        buf.limit(msgSz);
        buf.clear();
        for (int size = msgSz; size > 0; size -= read) {
            read = this.chan.read(buf);
            if (read >= 0) continue;
            throw new AsterixException("Socket closed");
        }
        buf.flip();
    }

    @Override
    public void quit() throws HyracksDataException {
        this.messageBuilder.quit();
    }

    public ProcessHandle getPid() {
        return this.pid;
    }
}

