/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IDataParser;
import org.apache.asterix.external.api.IExternalDataRuntimeContext;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IStreamDataParser;
import org.apache.asterix.external.input.filter.embedder.IExternalFilterValueEmbedder;
import org.apache.asterix.external.parser.AbstractDataParser;
import org.apache.asterix.external.parser.jackson.ParserContext;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParser;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;
import org.apache.hyracks.dataflow.std.file.FieldCursorForDelimitedDataParser;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.hyracks.util.ParseUtil;

public class DelimitedDataParser
extends AbstractDataParser
implements IStreamDataParser,
IRecordDataParser<char[]> {
    private final IWarningCollector warnings;
    private final char fieldDelimiter;
    private final char quote;
    private final boolean hasHeader;
    private final ARecordType recordType;
    private final IARecordBuilder recBuilder;
    private final ArrayBackedValueStorage fieldValueBuffer;
    private final DataOutput fieldValueBufferOutput;
    private final IValueParser[] valueParsers;
    private final Supplier<String> dataSourceName;
    private final LongSupplier lineNumber;
    private final byte[] fieldTypeTags;
    private final int[] fldIds;
    private final ArrayBackedValueStorage[] nameBuffers;
    private final String[] fieldNames;
    private final char[] nullChars;
    private final IExternalFilterValueEmbedder valueEmbedder;
    private final ParserContext parserContext;
    private FieldCursorForDelimitedDataParser cursor;

    public DelimitedDataParser(IExternalDataRuntimeContext context, IValueParserFactory[] valueParserFactories, char fieldDelimiter, char quote, boolean hasHeader, ARecordType recordType, boolean isStreamParser, String nullString) throws HyracksDataException {
        this.dataSourceName = context.getDatasourceNameSupplier();
        this.lineNumber = context.getLineNumberSupplier();
        this.warnings = context.getTaskContext().getWarningCollector();
        this.valueEmbedder = context.getValueEmbedder();
        this.fieldDelimiter = fieldDelimiter;
        this.quote = quote;
        this.hasHeader = hasHeader;
        this.recordType = recordType;
        this.valueParsers = new IValueParser[valueParserFactories.length];
        for (int i = 0; i < valueParserFactories.length; ++i) {
            this.valueParsers[i] = valueParserFactories[i].createValueParser();
        }
        this.fieldValueBuffer = new ArrayBackedValueStorage();
        this.fieldValueBufferOutput = this.fieldValueBuffer.getDataOutput();
        this.recBuilder = new RecordBuilder();
        this.recBuilder.reset(recordType);
        this.recBuilder.init();
        int n = recordType.getFieldNames().length;
        this.fieldTypeTags = new byte[n];
        for (int i = 0; i < n; ++i) {
            ATypeTag tag = recordType.getFieldTypes()[i].getTypeTag();
            this.fieldTypeTags[i] = tag.serialize();
        }
        this.fldIds = new int[n];
        this.nameBuffers = new ArrayBackedValueStorage[n];
        this.fieldNames = new String[n];
        AMutableString str = new AMutableString(null);
        for (int i = 0; i < n; ++i) {
            String name = recordType.getFieldNames()[i];
            this.fldIds[i] = this.recBuilder.getFieldId(name);
            if (this.fldIds[i] < 0) {
                if (!recordType.isOpen()) {
                    throw new RuntimeDataException(ErrorCode.PARSER_DELIMITED_ILLEGAL_FIELD, new Serializable[]{LogRedactionUtil.userData((String)name), recordType});
                }
                this.nameBuffers[i] = new ArrayBackedValueStorage();
                str.setValue(name);
                IDataParser.toBytes(str, this.nameBuffers[i], this.stringSerde);
            }
            this.fieldNames[i] = name;
        }
        if (!isStreamParser) {
            this.cursor = new FieldCursorForDelimitedDataParser(null, this.fieldDelimiter, quote, this.warnings, this::getDataSourceName);
        }
        this.nullChars = nullString != null ? nullString.toCharArray() : null;
        this.parserContext = new ParserContext();
    }

    @Override
    public boolean parse(DataOutput out) throws HyracksDataException {
        try {
            if (this.cursor.nextRecord()) {
                if (this.parseRecord()) {
                    this.recBuilder.write(out, true);
                    return true;
                }
                throw new RuntimeDataException(ErrorCode.FAILED_TO_PARSE_RECORD, new Serializable[0]);
            }
            return false;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private boolean parseRecord() throws HyracksDataException {
        this.recBuilder.reset(this.recordType);
        this.recBuilder.init();
        for (int i = 0; i < this.valueParsers.length; ++i) {
            try {
                FieldCursorForDelimitedDataParser.Result result = this.cursor.nextField();
                switch (result) {
                    case OK: {
                        break;
                    }
                    case END: {
                        if (this.warnings.shouldWarn()) {
                            ParseUtil.warn((IWarningCollector)this.warnings, (String)this.dataSourceName.get(), (long)this.cursor.getLineCount(), (int)this.cursor.getFieldCount(), (String)"some fields are missing");
                        }
                        return false;
                    }
                    case ERROR: {
                        return false;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                this.fieldValueBuffer.reset();
                if (this.nullChars != null && NonTaggedFormatUtil.isOptional((IAType)this.recordType.getFieldTypes()[i]) && this.fieldNull()) {
                    this.fieldValueBufferOutput.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                } else {
                    boolean success;
                    if (this.cursor.isFieldEmpty() && !DelimitedDataParser.canProcessEmptyField(this.recordType.getFieldTypes()[i])) {
                        if (this.warnings.shouldWarn()) {
                            ParseUtil.warn((IWarningCollector)this.warnings, (String)this.dataSourceName.get(), (long)this.cursor.getLineCount(), (int)this.cursor.getFieldCount(), (String)"empty value");
                        }
                        return false;
                    }
                    this.fieldValueBufferOutput.writeByte(this.fieldTypeTags[i]);
                    if (this.cursor.fieldHasDoubleQuote()) {
                        this.cursor.eliminateDoubleQuote();
                    }
                    if (!(success = this.valueParsers[i].parse(this.cursor.getBuffer(), this.cursor.getFieldStart(), this.cursor.getFieldLength(), this.fieldValueBufferOutput))) {
                        if (this.warnings.shouldWarn()) {
                            ParseUtil.warn((IWarningCollector)this.warnings, (String)this.dataSourceName.get(), (long)this.cursor.getLineCount(), (int)this.cursor.getFieldCount(), (String)"invalid value");
                        }
                        return false;
                    }
                }
                this.addValue(i);
                continue;
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        try {
            while (this.cursor.nextField() == FieldCursorForDelimitedDataParser.Result.OK) {
            }
            return true;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public boolean parse(IRawRecord<? extends char[]> record, DataOutput out) throws HyracksDataException {
        this.cursor.nextRecord(record.get(), record.size(), this.lineNumber.getAsLong());
        this.valueEmbedder.reset();
        this.valueEmbedder.enterObject();
        if (this.parseRecord()) {
            this.valueEmbedder.exitObject();
            this.finalizeEmbedding();
            this.recBuilder.write(out, true);
            return true;
        }
        return false;
    }

    @Override
    public void setInputStream(InputStream in) throws IOException {
        this.cursor = new FieldCursorForDelimitedDataParser((Reader)new InputStreamReader(in), this.fieldDelimiter, this.quote, this.warnings, this::getDataSourceName);
        if (this.hasHeader) {
            FieldCursorForDelimitedDataParser.Result result;
            this.cursor.nextRecord();
            while ((result = this.cursor.nextField()) == FieldCursorForDelimitedDataParser.Result.OK) {
            }
            if (result == FieldCursorForDelimitedDataParser.Result.ERROR) {
                throw new RuntimeDataException(ErrorCode.FAILED_TO_PARSE_RECORD, new Serializable[0]);
            }
        }
    }

    @Override
    public boolean reset(InputStream in) throws IOException {
        this.cursor = new FieldCursorForDelimitedDataParser((Reader)new InputStreamReader(in), this.fieldDelimiter, this.quote, this.warnings, this::getDataSourceName);
        return true;
    }

    private void addValue(int index) throws HyracksDataException {
        ArrayBackedValueStorage value = this.fieldValueBuffer;
        if (this.valueEmbedder.shouldEmbed(this.fieldNames[index], ATypeTag.VALUE_TYPE_MAPPING[this.fieldTypeTags[index]])) {
            value = this.valueEmbedder.getEmbeddedValue();
        }
        if (this.fldIds[index] < 0) {
            this.recBuilder.addField((IValueReference)this.nameBuffers[index], (IValueReference)value);
        } else {
            this.recBuilder.addField(this.fldIds[index], (IValueReference)value);
        }
    }

    private String getDataSourceName() {
        return this.dataSourceName.get();
    }

    private static boolean canProcessEmptyField(IAType fieldType) {
        IAType type = TypeComputeUtils.getActualType((IAType)fieldType);
        return type.getTypeTag() == ATypeTag.STRING || type.getTypeTag() == ATypeTag.NULL;
    }

    private boolean fieldNull() {
        int nullStringLength;
        int fieldLength = this.cursor.getFieldLength();
        if (fieldLength != (nullStringLength = this.nullChars.length)) {
            return false;
        }
        char[] fieldChars = this.cursor.getBuffer();
        int fieldStart = this.cursor.getFieldStart();
        for (int i = 0; i < fieldLength; ++i) {
            if (fieldChars[fieldStart + i] == this.nullChars[i]) continue;
            return false;
        }
        return true;
    }

    private void finalizeEmbedding() throws HyracksDataException {
        if (this.valueEmbedder.isMissingEmbeddedValues()) {
            String[] embeddedFieldNames = this.valueEmbedder.getEmbeddedFieldNames();
            for (int i = 0; i < embeddedFieldNames.length; ++i) {
                String embeddedFieldName = embeddedFieldNames[i];
                int index = this.recordType.getFieldIndex(embeddedFieldName);
                if (!this.valueEmbedder.isMissing(embeddedFieldName)) continue;
                IValueReference embeddedValue = this.valueEmbedder.getEmbeddedValue();
                if (index < 0) {
                    this.recBuilder.addField(this.getSerializedFieldName(embeddedFieldName), embeddedValue);
                    continue;
                }
                this.recBuilder.addField(index, embeddedValue);
            }
        }
    }

    private IValueReference getSerializedFieldName(String fieldName) throws HyracksDataException {
        try {
            return this.parserContext.getSerializedFieldName(fieldName);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

