/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser.factory;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.parser.factory.AbstractRecordStreamParserFactory;
import org.apache.asterix.external.parser.factory.JSONDataParserFactory;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;

public abstract class AbstractGenericDataParserFactory<T>
extends AbstractRecordStreamParserFactory<T> {
    private static final long serialVersionUID = 1L;
    private static final List<ATypeTag> UNSUPPORTED_TYPES = Collections.unmodifiableList(Arrays.asList(ATypeTag.MULTISET, ATypeTag.POINT3D, ATypeTag.CIRCLE, ATypeTag.RECTANGLE, ATypeTag.INTERVAL, ATypeTag.DAYTIMEDURATION, ATypeTag.DURATION, ATypeTag.BINARY));

    @Override
    public void setRecordType(ARecordType recordType) throws AsterixException {
        this.checkRecordTypeCompatibility(recordType);
        super.setRecordType(recordType);
    }

    private void checkRecordTypeCompatibility(ARecordType recordType) throws AsterixException {
        IAType[] fieldTypes;
        for (IAType type : fieldTypes = recordType.getFieldTypes()) {
            this.checkTypeCompatibility(type);
        }
    }

    private void checkTypeCompatibility(IAType type) throws AsterixException {
        if (UNSUPPORTED_TYPES.contains(type.getTypeTag())) {
            throw new AsterixException(ErrorCode.TYPE_UNSUPPORTED, new Serializable[]{JSONDataParserFactory.class.getName(), type.getTypeTag().toString()});
        }
        if (type.getTypeTag() == ATypeTag.ARRAY) {
            this.checkTypeCompatibility(((AOrderedListType)type).getItemType());
        } else if (type.getTypeTag() == ATypeTag.OBJECT) {
            this.checkRecordTypeCompatibility((ARecordType)type);
        } else if (type.getTypeTag() == ATypeTag.UNION) {
            this.checkTypeCompatibility(((AUnionType)type).getActualType());
        }
    }
}

