/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class DataverseDropStatement
extends AbstractStatement {
    private final Namespace namespace;
    private final boolean ifExists;
    private final boolean ifEmpty;

    public DataverseDropStatement(Namespace namespace, boolean ifExists) {
        this(namespace, ifExists, false);
    }

    public DataverseDropStatement(Namespace namespace, boolean ifExists, boolean ifEmpty) {
        this.namespace = Objects.requireNonNull(namespace);
        this.ifExists = ifExists;
        this.ifEmpty = ifEmpty;
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.DATAVERSE_DROP;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getDatabaseName() {
        return this.namespace.getDatabaseName();
    }

    public DataverseName getDataverseName() {
        return this.namespace == null ? null : this.namespace.getDataverseName();
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    public boolean getIfEmpty() {
        return this.ifEmpty;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    @Override
    public byte getCategory() {
        return 4;
    }
}

