/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.replication.IIOReplicationManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IExtraPageBlockHelper;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageWriter;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;
import org.apache.hyracks.storage.common.file.IFileMapManager;
import org.apache.hyracks.util.JSONUtil;

public class MultitenantVirtualBufferCache
implements IVirtualBufferCache {
    private final IVirtualBufferCache vbc;
    private int openCount;

    public MultitenantVirtualBufferCache(IVirtualBufferCache virtualBufferCache) {
        this.vbc = virtualBufferCache;
        this.openCount = 0;
    }

    public int createFile(FileReference fileRef) throws HyracksDataException {
        return this.vbc.createFile(fileRef);
    }

    public void openFile(int fileId) throws HyracksDataException {
        this.vbc.openFile(fileId);
    }

    public void closeFile(int fileId) throws HyracksDataException {
        this.vbc.closeFile(fileId);
    }

    public void deleteFile(int fileId) throws HyracksDataException {
        this.vbc.deleteFile(fileId);
    }

    public ICachedPage pin(long dpid, boolean newPage) throws HyracksDataException {
        return this.vbc.pin(dpid, newPage);
    }

    public ICachedPage pin(long dpid, boolean newPage, boolean incrementStats) throws HyracksDataException {
        return this.vbc.pin(dpid, newPage);
    }

    public void unpin(ICachedPage page) throws HyracksDataException {
        this.vbc.unpin(page);
    }

    public void flush(ICachedPage page) throws HyracksDataException {
        this.vbc.flush(page);
    }

    public void force(int fileId, boolean metadata) throws HyracksDataException {
        this.vbc.force(fileId, metadata);
    }

    public int getPageSize() {
        return this.vbc.getPageSize();
    }

    public int getPageSizeWithHeader() {
        return this.vbc.getPageSizeWithHeader();
    }

    public int getPageBudget() {
        return this.vbc.getPageBudget();
    }

    public synchronized void close() throws HyracksDataException {
        --this.openCount;
        if (this.openCount == 0) {
            this.vbc.close();
        }
    }

    @Override
    public synchronized void open() throws HyracksDataException {
        ++this.openCount;
        if (this.openCount == 1) {
            boolean failed = true;
            try {
                this.vbc.open();
                failed = false;
            }
            finally {
                if (failed) {
                    --this.openCount;
                }
            }
        }
    }

    @Override
    public boolean isFull() {
        return this.vbc.isFull();
    }

    @Override
    public IFileMapManager getFileMapProvider() {
        return this.vbc.getFileMapProvider();
    }

    public int getNumPagesOfFile(int fileId) throws HyracksDataException {
        return this.vbc.getNumPagesOfFile(fileId);
    }

    public ICachedPage confiscatePage(long dpid) throws HyracksDataException {
        return this.vbc.confiscatePage(dpid);
    }

    public ICachedPage confiscateLargePage(long dpid, int multiplier, int extraBlockPageId) throws HyracksDataException {
        return this.vbc.confiscateLargePage(dpid, multiplier, extraBlockPageId);
    }

    public void returnPage(ICachedPage page) {
        this.vbc.returnPage(page);
    }

    public IFIFOPageWriter createFIFOWriter(IPageWriteCallback callback, IPageWriteFailureCallback failureCallback) {
        return this.vbc.createFIFOWriter(callback, failureCallback);
    }

    public void returnPage(ICachedPage page, boolean reinsert) {
    }

    public int getFileReferenceCount(int fileId) {
        return 0;
    }

    public boolean isReplicationEnabled() {
        return false;
    }

    public IIOReplicationManager getIOReplicationManager() {
        return null;
    }

    public void purgeHandle(int fileId) throws HyracksDataException {
    }

    public void resizePage(ICachedPage page, int multiplier, IExtraPageBlockHelper extraPageBlockHelper) throws HyracksDataException {
        this.vbc.resizePage(page, multiplier, extraPageBlockHelper);
    }

    public String toString() {
        return JSONUtil.fromMap(this.toMap());
    }

    private Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("class", this.getClass().getSimpleName());
        map.put("vbc", this.vbc.toString());
        map.put("openCount", this.openCount);
        return map;
    }

    public int openFile(FileReference fileRef) throws HyracksDataException {
        return this.vbc.openFile(fileRef);
    }

    public void deleteFile(FileReference file) throws HyracksDataException {
        this.vbc.deleteFile(file);
    }

    public void closeFileIfOpen(FileReference fileRef) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFull(ILSMMemoryComponent memoryComponent) {
        return this.vbc.isFull(memoryComponent);
    }

    @Override
    public int getUsage() {
        return this.vbc.getUsage();
    }

    @Override
    public void register(ILSMMemoryComponent memoryComponent) {
        this.vbc.register(memoryComponent);
    }

    @Override
    public void unregister(ILSMMemoryComponent memoryComponent) {
        this.vbc.unregister(memoryComponent);
    }

    @Override
    public void flushed(ILSMMemoryComponent memoryComponent) throws HyracksDataException {
        this.vbc.flushed(memoryComponent);
    }
}

