/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class SimilarityCheckRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.SELECT) {
            return false;
        }
        SelectOperator select = (SelectOperator)op;
        Mutable condExpr = select.getCondition();
        ArrayList<AssignOperator> assigns = new ArrayList<AssignOperator>();
        AbstractLogicalOperator childOp = (AbstractLogicalOperator)((Mutable)select.getInputs().get(0)).getValue();
        while (childOp.getOperatorTag() == LogicalOperatorTag.SELECT) {
            childOp = (AbstractLogicalOperator)((Mutable)childOp.getInputs().get(0)).getValue();
        }
        while (childOp.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            assigns.add((AssignOperator)childOp);
            childOp = (AbstractLogicalOperator)((Mutable)childOp.getInputs().get(0)).getValue();
        }
        return this.replaceSelectConditionExprs((Mutable<ILogicalExpression>)condExpr, assigns, context);
    }

    private boolean replaceSelectConditionExprs(Mutable<ILogicalExpression> expRef, List<AssignOperator> assigns, IOptimizationContext context) throws AlgebricksException {
        ILogicalExpression expr = (ILogicalExpression)expRef.getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        FunctionIdentifier funcIdent = funcExpr.getFunctionIdentifier();
        if (funcIdent == AlgebricksBuiltinFunctions.AND) {
            boolean found = true;
            for (int i = 0; i < funcExpr.getArguments().size(); ++i) {
                found = found && this.replaceSelectConditionExprs((Mutable<ILogicalExpression>)((Mutable)funcExpr.getArguments().get(i)), assigns, context);
            }
            return found;
        }
        if (funcIdent != AlgebricksBuiltinFunctions.GE && funcIdent != AlgebricksBuiltinFunctions.GT && funcIdent != AlgebricksBuiltinFunctions.LE && funcIdent != AlgebricksBuiltinFunctions.LT) {
            return false;
        }
        AsterixConstantValue constVal = null;
        ILogicalExpression nonConstExpr = null;
        ILogicalExpression arg1 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue();
        ILogicalExpression arg2 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(1)).getValue();
        FunctionIdentifier normFuncIdent = null;
        if (arg1.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
            ConstantExpression constExpr = (ConstantExpression)arg1;
            constVal = (AsterixConstantValue)constExpr.getValue();
            nonConstExpr = arg2;
            normFuncIdent = this.getLhsAndRhsSwappedFuncIdent(funcIdent);
        } else if (arg2.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
            ConstantExpression constExpr = (ConstantExpression)arg2;
            constVal = (AsterixConstantValue)constExpr.getValue();
            nonConstExpr = arg1;
            normFuncIdent = funcIdent;
        } else {
            return false;
        }
        if (nonConstExpr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            return this.replaceWithFunctionCallArg(expRef, normFuncIdent, constVal, (AbstractFunctionCallExpression)nonConstExpr);
        }
        if (nonConstExpr.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            return this.replaceWithVariableArg(expRef, normFuncIdent, constVal, (VariableReferenceExpression)nonConstExpr, assigns, context);
        }
        return false;
    }

    private boolean replaceWithVariableArg(Mutable<ILogicalExpression> expRef, FunctionIdentifier normFuncIdent, AsterixConstantValue constVal, VariableReferenceExpression varRefExpr, List<AssignOperator> assigns, IOptimizationContext context) throws AlgebricksException {
        LogicalVariable var = varRefExpr.getVariableReference();
        Mutable simFuncExprRef = null;
        ScalarFunctionCallExpression simCheckFuncExpr = null;
        AssignOperator matchingAssign = null;
        for (int i = 0; i < assigns.size(); ++i) {
            AssignOperator assign = assigns.get(i);
            for (int j = 0; j < assign.getVariables().size(); ++j) {
                if (var != assign.getVariables().get(j) || ((ILogicalExpression)((Mutable)assign.getExpressions().get(j)).getValue()).getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
                simFuncExprRef = (Mutable)assign.getExpressions().get(j);
                simCheckFuncExpr = this.getSimilarityCheckExpr(normFuncIdent, constVal, (AbstractFunctionCallExpression)simFuncExprRef.getValue());
                matchingAssign = assign;
                break;
            }
            if (simCheckFuncExpr != null) break;
        }
        if (simCheckFuncExpr != null) {
            SourceLocation sourceLoc = simCheckFuncExpr.getSourceLocation();
            LogicalVariable newVar = context.newVar();
            AssignOperator newAssign = new AssignOperator(newVar, (Mutable)new MutableObject(simCheckFuncExpr));
            newAssign.setSourceLocation(sourceLoc);
            newAssign.getInputs().add(new MutableObject((Object)((ILogicalOperator)((Mutable)matchingAssign.getInputs().get(0)).getValue())));
            ((Mutable)matchingAssign.getInputs().get(0)).setValue((Object)newAssign);
            ArrayList<MutableObject> selectGetItemArgs = new ArrayList<MutableObject>();
            VariableReferenceExpression newVarRef1 = new VariableReferenceExpression(newVar);
            newVarRef1.setSourceLocation(sourceLoc);
            selectGetItemArgs.add(new MutableObject((Object)newVarRef1));
            selectGetItemArgs.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(0)))));
            ScalarFunctionCallExpression selectGetItemExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.GET_ITEM), selectGetItemArgs);
            selectGetItemExpr.setSourceLocation(sourceLoc);
            expRef.setValue((Object)selectGetItemExpr);
            ArrayList<MutableObject> assignGetItemArgs = new ArrayList<MutableObject>();
            VariableReferenceExpression newVarRef2 = new VariableReferenceExpression(newVar);
            newVarRef2.setSourceLocation(sourceLoc);
            assignGetItemArgs.add(new MutableObject((Object)newVarRef2));
            assignGetItemArgs.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(1)))));
            ScalarFunctionCallExpression assignGetItemExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.GET_ITEM), assignGetItemArgs);
            assignGetItemExpr.setSourceLocation(sourceLoc);
            simFuncExprRef.setValue((Object)assignGetItemExpr);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newAssign);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)matchingAssign);
            return true;
        }
        return false;
    }

    private boolean replaceWithFunctionCallArg(Mutable<ILogicalExpression> expRef, FunctionIdentifier normFuncIdent, AsterixConstantValue constVal, AbstractFunctionCallExpression funcExpr) throws AlgebricksException {
        ScalarFunctionCallExpression simCheckFuncExpr = this.getSimilarityCheckExpr(normFuncIdent, constVal, funcExpr);
        if (simCheckFuncExpr != null) {
            ArrayList<MutableObject> getItemArgs = new ArrayList<MutableObject>();
            getItemArgs.add(new MutableObject((Object)simCheckFuncExpr));
            getItemArgs.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(0)))));
            ScalarFunctionCallExpression getItemExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.GET_ITEM), getItemArgs);
            getItemExpr.setSourceLocation(simCheckFuncExpr.getSourceLocation());
            expRef.setValue((Object)getItemExpr);
            return true;
        }
        return false;
    }

    private ScalarFunctionCallExpression getSimilarityCheckExpr(FunctionIdentifier normFuncIdent, AsterixConstantValue constVal, AbstractFunctionCallExpression funcExpr) throws AlgebricksException {
        ArrayList<MutableObject> similarityArgs = null;
        ScalarFunctionCallExpression simCheckFuncExpr = null;
        if (funcExpr.getFunctionIdentifier() == BuiltinFunctions.SIMILARITY_JACCARD) {
            Object jaccThresh;
            if (normFuncIdent == AlgebricksBuiltinFunctions.GE) {
                jaccThresh = constVal.getObject() instanceof AFloat ? constVal.getObject() : new AFloat((float)((ADouble)constVal.getObject()).getDoubleValue());
            } else if (normFuncIdent == AlgebricksBuiltinFunctions.GT) {
                float threshVal = 0.0f;
                threshVal = constVal.getObject() instanceof AFloat ? ((AFloat)constVal.getObject()).getFloatValue() : (float)((ADouble)constVal.getObject()).getDoubleValue();
                float f = threshVal + Float.MIN_VALUE;
                if (f > 1.0f) {
                    f = 1.0f;
                }
                jaccThresh = new AFloat(f);
            } else {
                return null;
            }
            similarityArgs = new ArrayList<MutableObject>();
            similarityArgs.addAll(funcExpr.getArguments());
            similarityArgs.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue(jaccThresh))));
            simCheckFuncExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SIMILARITY_JACCARD_CHECK), similarityArgs);
            simCheckFuncExpr.setSourceLocation(funcExpr.getSourceLocation());
        }
        if (funcExpr.getFunctionIdentifier() == BuiltinFunctions.EDIT_DISTANCE) {
            AInt32 edThresh;
            AInt32 aInt = new AInt32(0);
            try {
                aInt = (AInt32)ATypeHierarchy.convertNumericTypeObject((IAObject)constVal.getObject(), (ATypeTag)ATypeTag.INTEGER);
            }
            catch (HyracksDataException e) {
                throw new AlgebricksException((Throwable)e);
            }
            if (normFuncIdent == AlgebricksBuiltinFunctions.LE) {
                edThresh = aInt;
            } else if (normFuncIdent == AlgebricksBuiltinFunctions.LT) {
                int ed = aInt.getIntegerValue() - 1;
                if (ed < 0) {
                    ed = 0;
                }
                edThresh = new AInt32(ed);
            } else {
                return null;
            }
            similarityArgs = new ArrayList();
            similarityArgs.addAll(funcExpr.getArguments());
            similarityArgs.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)edThresh))));
            simCheckFuncExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.EDIT_DISTANCE_CHECK), similarityArgs);
            simCheckFuncExpr.setSourceLocation(funcExpr.getSourceLocation());
        }
        if (simCheckFuncExpr != null) {
            funcExpr.copyAnnotationsInto(simCheckFuncExpr);
        }
        return simCheckFuncExpr;
    }

    private FunctionIdentifier getLhsAndRhsSwappedFuncIdent(FunctionIdentifier oldFuncIdent) {
        if (oldFuncIdent == AlgebricksBuiltinFunctions.GE) {
            return AlgebricksBuiltinFunctions.LE;
        }
        if (oldFuncIdent == AlgebricksBuiltinFunctions.GT) {
            return AlgebricksBuiltinFunctions.LT;
        }
        if (oldFuncIdent == AlgebricksBuiltinFunctions.LE) {
            return AlgebricksBuiltinFunctions.GE;
        }
        if (oldFuncIdent == AlgebricksBuiltinFunctions.LT) {
            return AlgebricksBuiltinFunctions.GT;
        }
        throw new IllegalStateException();
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }
}

