/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.metadata.utils.PushdownUtil;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.optimizer.rules.pushdown.PushdownContext;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.DefineDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.ScanDefineDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.UseDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.processor.AbstractPushdownProcessor;
import org.apache.asterix.optimizer.rules.pushdown.visitor.FilterExpressionInlineVisitor;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;

abstract class AbstractFilterPushdownProcessor
extends AbstractPushdownProcessor {
    private final Set<ILogicalOperator> visitedOperators = new HashSet<ILogicalOperator>();
    private final Map<ILogicalOperator, List<UseDescriptor>> subplanSelects = new HashMap<ILogicalOperator, List<UseDescriptor>>();
    private final List<UseDescriptor> scanCandidateFilters = new ArrayList<UseDescriptor>();
    private final Set<LogicalVariable> subplanProducedVariables = new HashSet<LogicalVariable>();

    public AbstractFilterPushdownProcessor(PushdownContext pushdownContext, IOptimizationContext context) {
        super(pushdownContext, context);
    }

    @Override
    public final boolean process() throws AlgebricksException {
        List<ScanDefineDescriptor> scanDefineDescriptors = this.pushdownContext.getRegisteredScans();
        boolean changed = false;
        for (ScanDefineDescriptor scanDefineDescriptor : scanDefineDescriptors) {
            if (this.skip(scanDefineDescriptor)) continue;
            this.subplanSelects.clear();
            this.scanCandidateFilters.clear();
            this.prepareScan(scanDefineDescriptor);
            this.collectFiltersInformation(scanDefineDescriptor, scanDefineDescriptor);
            this.putPotentialSelects(scanDefineDescriptor);
            changed |= this.pushdownFilter(scanDefineDescriptor);
        }
        return changed;
    }

    protected abstract boolean skip(ScanDefineDescriptor var1) throws AlgebricksException;

    protected abstract void prepareScan(ScanDefineDescriptor var1);

    protected abstract void preparePushdown(UseDescriptor var1, ScanDefineDescriptor var2) throws AlgebricksException;

    protected abstract boolean isNotPushable(AbstractFunctionCallExpression var1);

    protected abstract boolean handleCompare(AbstractFunctionCallExpression var1) throws AlgebricksException;

    protected abstract boolean handlePath(AbstractFunctionCallExpression var1) throws AlgebricksException;

    protected abstract void putFilterInformation(ScanDefineDescriptor var1, ILogicalExpression var2) throws AlgebricksException;

    private void collectFiltersInformation(DefineDescriptor defineDescriptor, ScanDefineDescriptor scanDescriptor) {
        List<UseDescriptor> useDescriptors = this.pushdownContext.getUseDescriptors(defineDescriptor);
        for (UseDescriptor useDescriptor : useDescriptors) {
            if (this.visitedOperators.contains(useDescriptor.getOperator())) continue;
            if (this.canPushSelect(useDescriptor, scanDescriptor)) {
                this.scanCandidateFilters.add(useDescriptor);
                continue;
            }
            if (useDescriptor.getOperator().getOperatorTag() != LogicalOperatorTag.INNERJOIN) continue;
            this.scanCandidateFilters.add(useDescriptor);
        }
        for (UseDescriptor useDescriptor : useDescriptors) {
            DefineDescriptor nextDefineDescriptor = this.pushdownContext.getDefineDescriptor(useDescriptor);
            if (nextDefineDescriptor != null) {
                this.collectFiltersInformation(nextDefineDescriptor, scanDescriptor);
            }
            this.visitedOperators.add(useDescriptor.getOperator());
        }
    }

    private void putPotentialSelects(ScanDefineDescriptor scanDescriptor) throws AlgebricksException {
        for (Map.Entry<ILogicalOperator, List<UseDescriptor>> selects : this.subplanSelects.entrySet()) {
            ILogicalOperator subplan = selects.getKey();
            this.subplanProducedVariables.clear();
            VariableUtilities.getProducedVariables((ILogicalOperator)subplan, this.subplanProducedVariables);
            for (LogicalVariable producedVar : this.subplanProducedVariables) {
                DefineDescriptor defineDescriptor = this.pushdownContext.getDefineDescriptor(producedVar);
                if (defineDescriptor == null || this.visitedOperators.contains(defineDescriptor.getOperator()) || !PushdownUtil.isSupportedFilterAggregateFunction((ILogicalExpression)defineDescriptor.getExpression())) continue;
                this.collectFiltersInformation(defineDescriptor, scanDescriptor);
            }
        }
    }

    private boolean pushdownFilter(ScanDefineDescriptor scanDescriptor) throws AlgebricksException {
        boolean changed = false;
        for (UseDescriptor candidate : this.scanCandidateFilters) {
            changed |= this.inlineAndPushdownFilter(candidate, scanDescriptor);
        }
        return changed;
    }

    private boolean canPushSelect(UseDescriptor useDescriptor, ScanDefineDescriptor scanDescriptor) {
        ILogicalOperator useOperator = useDescriptor.getOperator();
        if (useDescriptor.getScope() != scanDescriptor.getScope()) {
            return false;
        }
        if (useOperator.getOperatorTag() != LogicalOperatorTag.SELECT && useOperator.getOperatorTag() != LogicalOperatorTag.DATASOURCESCAN) {
            return false;
        }
        boolean inSubplan = useDescriptor.inSubplan();
        if (inSubplan && useOperator.getOperatorTag() == LogicalOperatorTag.SELECT) {
            ILogicalOperator subplanOp = useDescriptor.getSubplanOperator();
            List selects = this.subplanSelects.computeIfAbsent(subplanOp, k -> new ArrayList());
            selects.add(useDescriptor);
        }
        return !inSubplan;
    }

    private boolean inlineAndPushdownFilter(UseDescriptor useDescriptor, ScanDefineDescriptor scanDefineDescriptor) throws AlgebricksException {
        boolean changed = false;
        FilterExpressionInlineVisitor inliningVisitor = this.pushdownContext.getInlineVisitor();
        ILogicalExpression inlinedExpr = inliningVisitor.cloneAndInline(useDescriptor, this.subplanSelects);
        this.preparePushdown(useDescriptor, scanDefineDescriptor);
        if (this.pushdownFilterExpression(inlinedExpr)) {
            this.putFilterInformation(scanDefineDescriptor, inlinedExpr);
            changed = true;
        }
        return changed;
    }

    protected final boolean pushdownFilterExpression(ILogicalExpression expression) throws AlgebricksException {
        boolean pushdown = false;
        if (PushdownUtil.isConstant((ILogicalExpression)expression)) {
            IAObject constantValue = PushdownUtil.getConstant((ILogicalExpression)expression);
            pushdown = !constantValue.getType().getTypeTag().isDerivedType();
        } else if (PushdownUtil.isAnd((ILogicalExpression)expression)) {
            pushdown = this.handleAnd((AbstractFunctionCallExpression)expression);
        } else if (PushdownUtil.isCompare((ILogicalExpression)expression)) {
            pushdown = this.handleCompare((AbstractFunctionCallExpression)expression);
        } else if (PushdownUtil.isFilterPath((ILogicalExpression)expression)) {
            pushdown = this.handlePath((AbstractFunctionCallExpression)expression);
        } else if (expression.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            pushdown = this.handleFunction((AbstractFunctionCallExpression)expression);
        }
        return pushdown;
    }

    private boolean handleAnd(AbstractFunctionCallExpression expression) throws AlgebricksException {
        List args = expression.getArguments();
        Iterator argIter = args.iterator();
        while (argIter.hasNext()) {
            ILogicalExpression arg = (ILogicalExpression)((Mutable)argIter.next()).getValue();
            if (this.pushdownFilterExpression(arg)) continue;
            argIter.remove();
        }
        return !args.isEmpty();
    }

    private boolean handleFunction(AbstractFunctionCallExpression expression) throws AlgebricksException {
        if (!expression.getFunctionInfo().isFunctional() || this.isNotPushable(expression)) {
            return false;
        }
        for (Mutable argRef : expression.getArguments()) {
            ILogicalExpression arg = (ILogicalExpression)argRef.getValue();
            if (this.pushdownFilterExpression(arg)) continue;
            return false;
        }
        return true;
    }
}

